/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.LabelSchema;
import com.amazonaws.services.frauddetector.model.ModelTypeEnum;
import com.amazonaws.services.frauddetector.model.ModelVariable;
import com.amazonaws.services.frauddetector.model.TrainingDataSource;
import com.amazonaws.services.frauddetector.model.transform.ModelVersionDetailMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelVersionDetail
implements Serializable,
Cloneable,
StructuredPojo {
    private String modelId;
    private String modelType;
    private String modelVersionNumber;
    private String description;
    private String status;
    private TrainingDataSource trainingDataSource;
    private List<ModelVariable> modelVariables;
    private LabelSchema labelSchema;
    private Map<String, String> validationMetrics;
    private Map<String, String> trainingMetrics;
    private String lastUpdatedTime;
    private String createdTime;

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public ModelVersionDetail withModelId(String modelId) {
        this.setModelId(modelId);
        return this;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public String getModelType() {
        return this.modelType;
    }

    public ModelVersionDetail withModelType(String modelType) {
        this.setModelType(modelType);
        return this;
    }

    public ModelVersionDetail withModelType(ModelTypeEnum modelType) {
        this.modelType = modelType.toString();
        return this;
    }

    public void setModelVersionNumber(String modelVersionNumber) {
        this.modelVersionNumber = modelVersionNumber;
    }

    public String getModelVersionNumber() {
        return this.modelVersionNumber;
    }

    public ModelVersionDetail withModelVersionNumber(String modelVersionNumber) {
        this.setModelVersionNumber(modelVersionNumber);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ModelVersionDetail withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ModelVersionDetail withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setTrainingDataSource(TrainingDataSource trainingDataSource) {
        this.trainingDataSource = trainingDataSource;
    }

    public TrainingDataSource getTrainingDataSource() {
        return this.trainingDataSource;
    }

    public ModelVersionDetail withTrainingDataSource(TrainingDataSource trainingDataSource) {
        this.setTrainingDataSource(trainingDataSource);
        return this;
    }

    public List<ModelVariable> getModelVariables() {
        return this.modelVariables;
    }

    public void setModelVariables(Collection<ModelVariable> modelVariables) {
        if (modelVariables == null) {
            this.modelVariables = null;
            return;
        }
        this.modelVariables = new ArrayList<ModelVariable>(modelVariables);
    }

    public ModelVersionDetail withModelVariables(ModelVariable ... modelVariables) {
        if (this.modelVariables == null) {
            this.setModelVariables(new ArrayList<ModelVariable>(modelVariables.length));
        }
        for (ModelVariable ele : modelVariables) {
            this.modelVariables.add(ele);
        }
        return this;
    }

    public ModelVersionDetail withModelVariables(Collection<ModelVariable> modelVariables) {
        this.setModelVariables(modelVariables);
        return this;
    }

    public void setLabelSchema(LabelSchema labelSchema) {
        this.labelSchema = labelSchema;
    }

    public LabelSchema getLabelSchema() {
        return this.labelSchema;
    }

    public ModelVersionDetail withLabelSchema(LabelSchema labelSchema) {
        this.setLabelSchema(labelSchema);
        return this;
    }

    public Map<String, String> getValidationMetrics() {
        return this.validationMetrics;
    }

    public void setValidationMetrics(Map<String, String> validationMetrics) {
        this.validationMetrics = validationMetrics;
    }

    public ModelVersionDetail withValidationMetrics(Map<String, String> validationMetrics) {
        this.setValidationMetrics(validationMetrics);
        return this;
    }

    public ModelVersionDetail addValidationMetricsEntry(String key, String value) {
        if (null == this.validationMetrics) {
            this.validationMetrics = new HashMap<String, String>();
        }
        if (this.validationMetrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.validationMetrics.put(key, value);
        return this;
    }

    public ModelVersionDetail clearValidationMetricsEntries() {
        this.validationMetrics = null;
        return this;
    }

    public Map<String, String> getTrainingMetrics() {
        return this.trainingMetrics;
    }

    public void setTrainingMetrics(Map<String, String> trainingMetrics) {
        this.trainingMetrics = trainingMetrics;
    }

    public ModelVersionDetail withTrainingMetrics(Map<String, String> trainingMetrics) {
        this.setTrainingMetrics(trainingMetrics);
        return this;
    }

    public ModelVersionDetail addTrainingMetricsEntry(String key, String value) {
        if (null == this.trainingMetrics) {
            this.trainingMetrics = new HashMap<String, String>();
        }
        if (this.trainingMetrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.trainingMetrics.put(key, value);
        return this;
    }

    public ModelVersionDetail clearTrainingMetricsEntries() {
        this.trainingMetrics = null;
        return this;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ModelVersionDetail withLastUpdatedTime(String lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public ModelVersionDetail withCreatedTime(String createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelId() != null) {
            sb.append("ModelId: ").append(this.getModelId()).append(",");
        }
        if (this.getModelType() != null) {
            sb.append("ModelType: ").append(this.getModelType()).append(",");
        }
        if (this.getModelVersionNumber() != null) {
            sb.append("ModelVersionNumber: ").append(this.getModelVersionNumber()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTrainingDataSource() != null) {
            sb.append("TrainingDataSource: ").append(this.getTrainingDataSource()).append(",");
        }
        if (this.getModelVariables() != null) {
            sb.append("ModelVariables: ").append(this.getModelVariables()).append(",");
        }
        if (this.getLabelSchema() != null) {
            sb.append("LabelSchema: ").append(this.getLabelSchema()).append(",");
        }
        if (this.getValidationMetrics() != null) {
            sb.append("ValidationMetrics: ").append(this.getValidationMetrics()).append(",");
        }
        if (this.getTrainingMetrics() != null) {
            sb.append("TrainingMetrics: ").append(this.getTrainingMetrics()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersionDetail)) {
            return false;
        }
        ModelVersionDetail other = (ModelVersionDetail)obj;
        if (other.getModelId() == null ^ this.getModelId() == null) {
            return false;
        }
        if (other.getModelId() != null && !other.getModelId().equals(this.getModelId())) {
            return false;
        }
        if (other.getModelType() == null ^ this.getModelType() == null) {
            return false;
        }
        if (other.getModelType() != null && !other.getModelType().equals(this.getModelType())) {
            return false;
        }
        if (other.getModelVersionNumber() == null ^ this.getModelVersionNumber() == null) {
            return false;
        }
        if (other.getModelVersionNumber() != null && !other.getModelVersionNumber().equals(this.getModelVersionNumber())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTrainingDataSource() == null ^ this.getTrainingDataSource() == null) {
            return false;
        }
        if (other.getTrainingDataSource() != null && !other.getTrainingDataSource().equals(this.getTrainingDataSource())) {
            return false;
        }
        if (other.getModelVariables() == null ^ this.getModelVariables() == null) {
            return false;
        }
        if (other.getModelVariables() != null && !other.getModelVariables().equals(this.getModelVariables())) {
            return false;
        }
        if (other.getLabelSchema() == null ^ this.getLabelSchema() == null) {
            return false;
        }
        if (other.getLabelSchema() != null && !other.getLabelSchema().equals(this.getLabelSchema())) {
            return false;
        }
        if (other.getValidationMetrics() == null ^ this.getValidationMetrics() == null) {
            return false;
        }
        if (other.getValidationMetrics() != null && !other.getValidationMetrics().equals(this.getValidationMetrics())) {
            return false;
        }
        if (other.getTrainingMetrics() == null ^ this.getTrainingMetrics() == null) {
            return false;
        }
        if (other.getTrainingMetrics() != null && !other.getTrainingMetrics().equals(this.getTrainingMetrics())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        return other.getCreatedTime() == null || other.getCreatedTime().equals(this.getCreatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelId() == null ? 0 : this.getModelId().hashCode());
        hashCode = 31 * hashCode + (this.getModelType() == null ? 0 : this.getModelType().hashCode());
        hashCode = 31 * hashCode + (this.getModelVersionNumber() == null ? 0 : this.getModelVersionNumber().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingDataSource() == null ? 0 : this.getTrainingDataSource().hashCode());
        hashCode = 31 * hashCode + (this.getModelVariables() == null ? 0 : this.getModelVariables().hashCode());
        hashCode = 31 * hashCode + (this.getLabelSchema() == null ? 0 : this.getLabelSchema().hashCode());
        hashCode = 31 * hashCode + (this.getValidationMetrics() == null ? 0 : this.getValidationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingMetrics() == null ? 0 : this.getTrainingMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        return hashCode;
    }

    public ModelVersionDetail clone() {
        try {
            return (ModelVersionDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ModelVersionDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

