/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.frauddetector.model.ModelEndpointDataBlob;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GetPredictionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String detectorId;
    private String detectorVersionId;
    private String eventId;
    private Map<String, String> eventAttributes;
    private Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs;

    public void setDetectorId(String detectorId) {
        this.detectorId = detectorId;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public GetPredictionRequest withDetectorId(String detectorId) {
        this.setDetectorId(detectorId);
        return this;
    }

    public void setDetectorVersionId(String detectorVersionId) {
        this.detectorVersionId = detectorVersionId;
    }

    public String getDetectorVersionId() {
        return this.detectorVersionId;
    }

    public GetPredictionRequest withDetectorVersionId(String detectorVersionId) {
        this.setDetectorVersionId(detectorVersionId);
        return this;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public GetPredictionRequest withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public Map<String, String> getEventAttributes() {
        return this.eventAttributes;
    }

    public void setEventAttributes(Map<String, String> eventAttributes) {
        this.eventAttributes = eventAttributes;
    }

    public GetPredictionRequest withEventAttributes(Map<String, String> eventAttributes) {
        this.setEventAttributes(eventAttributes);
        return this;
    }

    public GetPredictionRequest addEventAttributesEntry(String key, String value) {
        if (null == this.eventAttributes) {
            this.eventAttributes = new HashMap<String, String>();
        }
        if (this.eventAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.eventAttributes.put(key, value);
        return this;
    }

    public GetPredictionRequest clearEventAttributesEntries() {
        this.eventAttributes = null;
        return this;
    }

    public Map<String, ModelEndpointDataBlob> getExternalModelEndpointDataBlobs() {
        return this.externalModelEndpointDataBlobs;
    }

    public void setExternalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs) {
        this.externalModelEndpointDataBlobs = externalModelEndpointDataBlobs;
    }

    public GetPredictionRequest withExternalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs) {
        this.setExternalModelEndpointDataBlobs(externalModelEndpointDataBlobs);
        return this;
    }

    public GetPredictionRequest addExternalModelEndpointDataBlobsEntry(String key, ModelEndpointDataBlob value) {
        if (null == this.externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = new HashMap<String, ModelEndpointDataBlob>();
        }
        if (this.externalModelEndpointDataBlobs.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.externalModelEndpointDataBlobs.put(key, value);
        return this;
    }

    public GetPredictionRequest clearExternalModelEndpointDataBlobsEntries() {
        this.externalModelEndpointDataBlobs = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDetectorId() != null) {
            sb.append("DetectorId: ").append(this.getDetectorId()).append(",");
        }
        if (this.getDetectorVersionId() != null) {
            sb.append("DetectorVersionId: ").append(this.getDetectorVersionId()).append(",");
        }
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getEventAttributes() != null) {
            sb.append("EventAttributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExternalModelEndpointDataBlobs() != null) {
            sb.append("ExternalModelEndpointDataBlobs: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPredictionRequest)) {
            return false;
        }
        GetPredictionRequest other = (GetPredictionRequest)obj;
        if (other.getDetectorId() == null ^ this.getDetectorId() == null) {
            return false;
        }
        if (other.getDetectorId() != null && !other.getDetectorId().equals(this.getDetectorId())) {
            return false;
        }
        if (other.getDetectorVersionId() == null ^ this.getDetectorVersionId() == null) {
            return false;
        }
        if (other.getDetectorVersionId() != null && !other.getDetectorVersionId().equals(this.getDetectorVersionId())) {
            return false;
        }
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventAttributes() == null ^ this.getEventAttributes() == null) {
            return false;
        }
        if (other.getEventAttributes() != null && !other.getEventAttributes().equals(this.getEventAttributes())) {
            return false;
        }
        if (other.getExternalModelEndpointDataBlobs() == null ^ this.getExternalModelEndpointDataBlobs() == null) {
            return false;
        }
        return other.getExternalModelEndpointDataBlobs() == null || other.getExternalModelEndpointDataBlobs().equals(this.getExternalModelEndpointDataBlobs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDetectorId() == null ? 0 : this.getDetectorId().hashCode());
        hashCode = 31 * hashCode + (this.getDetectorVersionId() == null ? 0 : this.getDetectorVersionId().hashCode());
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventAttributes() == null ? 0 : this.getEventAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getExternalModelEndpointDataBlobs() == null ? 0 : this.getExternalModelEndpointDataBlobs().hashCode());
        return hashCode;
    }

    @Override
    public GetPredictionRequest clone() {
        return (GetPredictionRequest)super.clone();
    }
}

