/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.PredictorSummary;
import java.util.Date;

@SdkInternalApi
public class PredictorSummaryMarshaller {
    private static final MarshallingInfo<String> PREDICTORARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredictorArn").build();
    private static final MarshallingInfo<String> PREDICTORNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredictorName").build();
    private static final MarshallingInfo<String> DATASETGROUPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetGroupArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFICATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModificationTime").timestampFormat("unixTimestamp").build();
    private static final PredictorSummaryMarshaller instance = new PredictorSummaryMarshaller();

    public static PredictorSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(PredictorSummary predictorSummary, ProtocolMarshaller protocolMarshaller) {
        if (predictorSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(predictorSummary.getPredictorArn(), PREDICTORARN_BINDING);
            protocolMarshaller.marshall(predictorSummary.getPredictorName(), PREDICTORNAME_BINDING);
            protocolMarshaller.marshall(predictorSummary.getDatasetGroupArn(), DATASETGROUPARN_BINDING);
            protocolMarshaller.marshall(predictorSummary.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(predictorSummary.getMessage(), MESSAGE_BINDING);
            protocolMarshaller.marshall(predictorSummary.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(predictorSummary.getLastModificationTime(), LASTMODIFICATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

