/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.SchemaAttribute;
import com.amazonaws.services.forecast.model.transform.SchemaMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Schema
implements Serializable,
Cloneable,
StructuredPojo {
    private List<SchemaAttribute> attributes;

    public List<SchemaAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<SchemaAttribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<SchemaAttribute>(attributes);
    }

    public Schema withAttributes(SchemaAttribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<SchemaAttribute>(attributes.length));
        }
        for (SchemaAttribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public Schema withAttributes(Collection<SchemaAttribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public Schema clone() {
        try {
            return (Schema)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

