/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.TestWindowSummary;
import com.amazonaws.services.forecast.model.transform.PredictorExecutionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PredictorExecution
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithmArn;
    private List<TestWindowSummary> testWindows;

    public void setAlgorithmArn(String algorithmArn) {
        this.algorithmArn = algorithmArn;
    }

    public String getAlgorithmArn() {
        return this.algorithmArn;
    }

    public PredictorExecution withAlgorithmArn(String algorithmArn) {
        this.setAlgorithmArn(algorithmArn);
        return this;
    }

    public List<TestWindowSummary> getTestWindows() {
        return this.testWindows;
    }

    public void setTestWindows(Collection<TestWindowSummary> testWindows) {
        if (testWindows == null) {
            this.testWindows = null;
            return;
        }
        this.testWindows = new ArrayList<TestWindowSummary>(testWindows);
    }

    public PredictorExecution withTestWindows(TestWindowSummary ... testWindows) {
        if (this.testWindows == null) {
            this.setTestWindows(new ArrayList<TestWindowSummary>(testWindows.length));
        }
        for (TestWindowSummary ele : testWindows) {
            this.testWindows.add(ele);
        }
        return this;
    }

    public PredictorExecution withTestWindows(Collection<TestWindowSummary> testWindows) {
        this.setTestWindows(testWindows);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithmArn() != null) {
            sb.append("AlgorithmArn: ").append(this.getAlgorithmArn()).append(",");
        }
        if (this.getTestWindows() != null) {
            sb.append("TestWindows: ").append(this.getTestWindows());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorExecution)) {
            return false;
        }
        PredictorExecution other = (PredictorExecution)obj;
        if (other.getAlgorithmArn() == null ^ this.getAlgorithmArn() == null) {
            return false;
        }
        if (other.getAlgorithmArn() != null && !other.getAlgorithmArn().equals(this.getAlgorithmArn())) {
            return false;
        }
        if (other.getTestWindows() == null ^ this.getTestWindows() == null) {
            return false;
        }
        return other.getTestWindows() == null || other.getTestWindows().equals(this.getTestWindows());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithmArn() == null ? 0 : this.getAlgorithmArn().hashCode());
        hashCode = 31 * hashCode + (this.getTestWindows() == null ? 0 : this.getTestWindows().hashCode());
        return hashCode;
    }

    public PredictorExecution clone() {
        try {
            return (PredictorExecution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredictorExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

