/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.WeightedQuantileLoss;
import com.amazonaws.services.forecast.model.transform.MetricsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Metrics
implements Serializable,
Cloneable,
StructuredPojo {
    private Double rMSE;
    private List<WeightedQuantileLoss> weightedQuantileLosses;

    public void setRMSE(Double rMSE) {
        this.rMSE = rMSE;
    }

    public Double getRMSE() {
        return this.rMSE;
    }

    public Metrics withRMSE(Double rMSE) {
        this.setRMSE(rMSE);
        return this;
    }

    public List<WeightedQuantileLoss> getWeightedQuantileLosses() {
        return this.weightedQuantileLosses;
    }

    public void setWeightedQuantileLosses(Collection<WeightedQuantileLoss> weightedQuantileLosses) {
        if (weightedQuantileLosses == null) {
            this.weightedQuantileLosses = null;
            return;
        }
        this.weightedQuantileLosses = new ArrayList<WeightedQuantileLoss>(weightedQuantileLosses);
    }

    public Metrics withWeightedQuantileLosses(WeightedQuantileLoss ... weightedQuantileLosses) {
        if (this.weightedQuantileLosses == null) {
            this.setWeightedQuantileLosses(new ArrayList<WeightedQuantileLoss>(weightedQuantileLosses.length));
        }
        for (WeightedQuantileLoss ele : weightedQuantileLosses) {
            this.weightedQuantileLosses.add(ele);
        }
        return this;
    }

    public Metrics withWeightedQuantileLosses(Collection<WeightedQuantileLoss> weightedQuantileLosses) {
        this.setWeightedQuantileLosses(weightedQuantileLosses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRMSE() != null) {
            sb.append("RMSE: ").append(this.getRMSE()).append(",");
        }
        if (this.getWeightedQuantileLosses() != null) {
            sb.append("WeightedQuantileLosses: ").append(this.getWeightedQuantileLosses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics)obj;
        if (other.getRMSE() == null ^ this.getRMSE() == null) {
            return false;
        }
        if (other.getRMSE() != null && !other.getRMSE().equals(this.getRMSE())) {
            return false;
        }
        if (other.getWeightedQuantileLosses() == null ^ this.getWeightedQuantileLosses() == null) {
            return false;
        }
        return other.getWeightedQuantileLosses() == null || other.getWeightedQuantileLosses().equals(this.getWeightedQuantileLosses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRMSE() == null ? 0 : this.getRMSE().hashCode());
        hashCode = 31 * hashCode + (this.getWeightedQuantileLosses() == null ? 0 : this.getWeightedQuantileLosses().hashCode());
        return hashCode;
    }

    public Metrics clone() {
        try {
            return (Metrics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

