/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.Featurization;
import com.amazonaws.services.forecast.model.transform.FeaturizationConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FeaturizationConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String forecastFrequency;
    private List<String> forecastDimensions;
    private List<Featurization> featurizations;

    public void setForecastFrequency(String forecastFrequency) {
        this.forecastFrequency = forecastFrequency;
    }

    public String getForecastFrequency() {
        return this.forecastFrequency;
    }

    public FeaturizationConfig withForecastFrequency(String forecastFrequency) {
        this.setForecastFrequency(forecastFrequency);
        return this;
    }

    public List<String> getForecastDimensions() {
        return this.forecastDimensions;
    }

    public void setForecastDimensions(Collection<String> forecastDimensions) {
        if (forecastDimensions == null) {
            this.forecastDimensions = null;
            return;
        }
        this.forecastDimensions = new ArrayList<String>(forecastDimensions);
    }

    public FeaturizationConfig withForecastDimensions(String ... forecastDimensions) {
        if (this.forecastDimensions == null) {
            this.setForecastDimensions(new ArrayList<String>(forecastDimensions.length));
        }
        for (String ele : forecastDimensions) {
            this.forecastDimensions.add(ele);
        }
        return this;
    }

    public FeaturizationConfig withForecastDimensions(Collection<String> forecastDimensions) {
        this.setForecastDimensions(forecastDimensions);
        return this;
    }

    public List<Featurization> getFeaturizations() {
        return this.featurizations;
    }

    public void setFeaturizations(Collection<Featurization> featurizations) {
        if (featurizations == null) {
            this.featurizations = null;
            return;
        }
        this.featurizations = new ArrayList<Featurization>(featurizations);
    }

    public FeaturizationConfig withFeaturizations(Featurization ... featurizations) {
        if (this.featurizations == null) {
            this.setFeaturizations(new ArrayList<Featurization>(featurizations.length));
        }
        for (Featurization ele : featurizations) {
            this.featurizations.add(ele);
        }
        return this;
    }

    public FeaturizationConfig withFeaturizations(Collection<Featurization> featurizations) {
        this.setFeaturizations(featurizations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getForecastFrequency() != null) {
            sb.append("ForecastFrequency: ").append(this.getForecastFrequency()).append(",");
        }
        if (this.getForecastDimensions() != null) {
            sb.append("ForecastDimensions: ").append(this.getForecastDimensions()).append(",");
        }
        if (this.getFeaturizations() != null) {
            sb.append("Featurizations: ").append(this.getFeaturizations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeaturizationConfig)) {
            return false;
        }
        FeaturizationConfig other = (FeaturizationConfig)obj;
        if (other.getForecastFrequency() == null ^ this.getForecastFrequency() == null) {
            return false;
        }
        if (other.getForecastFrequency() != null && !other.getForecastFrequency().equals(this.getForecastFrequency())) {
            return false;
        }
        if (other.getForecastDimensions() == null ^ this.getForecastDimensions() == null) {
            return false;
        }
        if (other.getForecastDimensions() != null && !other.getForecastDimensions().equals(this.getForecastDimensions())) {
            return false;
        }
        if (other.getFeaturizations() == null ^ this.getFeaturizations() == null) {
            return false;
        }
        return other.getFeaturizations() == null || other.getFeaturizations().equals(this.getFeaturizations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getForecastFrequency() == null ? 0 : this.getForecastFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getForecastDimensions() == null ? 0 : this.getForecastDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getFeaturizations() == null ? 0 : this.getFeaturizations().hashCode());
        return hashCode;
    }

    public FeaturizationConfig clone() {
        try {
            return (FeaturizationConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FeaturizationConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

