/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ebs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ebs.model.Block;

@SdkInternalApi
public class BlockMarshaller {
    private static final MarshallingInfo<Integer> BLOCKINDEX_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockIndex").build();
    private static final MarshallingInfo<String> BLOCKTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockToken").build();
    private static final BlockMarshaller instance = new BlockMarshaller();

    public static BlockMarshaller getInstance() {
        return instance;
    }

    public void marshall(Block block, ProtocolMarshaller protocolMarshaller) {
        if (block == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(block.getBlockIndex(), BLOCKINDEX_BINDING);
            protocolMarshaller.marshall(block.getBlockToken(), BLOCKTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

