/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ebs;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ebs.AmazonEBSAsync;
import com.amazonaws.services.ebs.AmazonEBSAsyncClientBuilder;
import com.amazonaws.services.ebs.AmazonEBSClient;
import com.amazonaws.services.ebs.model.GetSnapshotBlockRequest;
import com.amazonaws.services.ebs.model.GetSnapshotBlockResult;
import com.amazonaws.services.ebs.model.ListChangedBlocksRequest;
import com.amazonaws.services.ebs.model.ListChangedBlocksResult;
import com.amazonaws.services.ebs.model.ListSnapshotBlocksRequest;
import com.amazonaws.services.ebs.model.ListSnapshotBlocksResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonEBSAsyncClient
extends AmazonEBSClient
implements AmazonEBSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonEBSAsyncClientBuilder asyncBuilder() {
        return AmazonEBSAsyncClientBuilder.standard();
    }

    AmazonEBSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetSnapshotBlockResult> getSnapshotBlockAsync(GetSnapshotBlockRequest request) {
        return this.getSnapshotBlockAsync(request, null);
    }

    @Override
    public Future<GetSnapshotBlockResult> getSnapshotBlockAsync(GetSnapshotBlockRequest request, final AsyncHandler<GetSnapshotBlockRequest, GetSnapshotBlockResult> asyncHandler) {
        final GetSnapshotBlockRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSnapshotBlockResult>(){

            @Override
            public GetSnapshotBlockResult call() throws Exception {
                GetSnapshotBlockResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executeGetSnapshotBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChangedBlocksResult> listChangedBlocksAsync(ListChangedBlocksRequest request) {
        return this.listChangedBlocksAsync(request, null);
    }

    @Override
    public Future<ListChangedBlocksResult> listChangedBlocksAsync(ListChangedBlocksRequest request, final AsyncHandler<ListChangedBlocksRequest, ListChangedBlocksResult> asyncHandler) {
        final ListChangedBlocksRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChangedBlocksResult>(){

            @Override
            public ListChangedBlocksResult call() throws Exception {
                ListChangedBlocksResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executeListChangedBlocks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSnapshotBlocksResult> listSnapshotBlocksAsync(ListSnapshotBlocksRequest request) {
        return this.listSnapshotBlocksAsync(request, null);
    }

    @Override
    public Future<ListSnapshotBlocksResult> listSnapshotBlocksAsync(ListSnapshotBlocksRequest request, final AsyncHandler<ListSnapshotBlocksRequest, ListSnapshotBlocksResult> asyncHandler) {
        final ListSnapshotBlocksRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSnapshotBlocksResult>(){

            @Override
            public ListSnapshotBlocksResult call() throws Exception {
                ListSnapshotBlocksResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executeListSnapshotBlocks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

