/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.RecommendationSourceType;
import com.amazonaws.services.computeoptimizer.model.Summary;
import com.amazonaws.services.computeoptimizer.model.transform.RecommendationSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecommendationSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Summary> summaries;
    private String recommendationResourceType;
    private String accountId;

    public List<Summary> getSummaries() {
        return this.summaries;
    }

    public void setSummaries(Collection<Summary> summaries) {
        if (summaries == null) {
            this.summaries = null;
            return;
        }
        this.summaries = new ArrayList<Summary>(summaries);
    }

    public RecommendationSummary withSummaries(Summary ... summaries) {
        if (this.summaries == null) {
            this.setSummaries(new ArrayList<Summary>(summaries.length));
        }
        for (Summary ele : summaries) {
            this.summaries.add(ele);
        }
        return this;
    }

    public RecommendationSummary withSummaries(Collection<Summary> summaries) {
        this.setSummaries(summaries);
        return this;
    }

    public void setRecommendationResourceType(String recommendationResourceType) {
        this.recommendationResourceType = recommendationResourceType;
    }

    public String getRecommendationResourceType() {
        return this.recommendationResourceType;
    }

    public RecommendationSummary withRecommendationResourceType(String recommendationResourceType) {
        this.setRecommendationResourceType(recommendationResourceType);
        return this;
    }

    public RecommendationSummary withRecommendationResourceType(RecommendationSourceType recommendationResourceType) {
        this.recommendationResourceType = recommendationResourceType.toString();
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public RecommendationSummary withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSummaries() != null) {
            sb.append("Summaries: ").append(this.getSummaries()).append(",");
        }
        if (this.getRecommendationResourceType() != null) {
            sb.append("RecommendationResourceType: ").append(this.getRecommendationResourceType()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary)obj;
        if (other.getSummaries() == null ^ this.getSummaries() == null) {
            return false;
        }
        if (other.getSummaries() != null && !other.getSummaries().equals(this.getSummaries())) {
            return false;
        }
        if (other.getRecommendationResourceType() == null ^ this.getRecommendationResourceType() == null) {
            return false;
        }
        if (other.getRecommendationResourceType() != null && !other.getRecommendationResourceType().equals(this.getRecommendationResourceType())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        return other.getAccountId() == null || other.getAccountId().equals(this.getAccountId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSummaries() == null ? 0 : this.getSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationResourceType() == null ? 0 : this.getRecommendationResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        return hashCode;
    }

    public RecommendationSummary clone() {
        try {
            return (RecommendationSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecommendationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

