/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.MetricName;
import com.amazonaws.services.computeoptimizer.model.transform.ProjectedMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ProjectedMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<Date> timestamps;
    private List<Double> values;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ProjectedMetric withName(String name) {
        this.setName(name);
        return this;
    }

    public ProjectedMetric withName(MetricName name) {
        this.name = name.toString();
        return this;
    }

    public List<Date> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(Collection<Date> timestamps) {
        if (timestamps == null) {
            this.timestamps = null;
            return;
        }
        this.timestamps = new ArrayList<Date>(timestamps);
    }

    public ProjectedMetric withTimestamps(Date ... timestamps) {
        if (this.timestamps == null) {
            this.setTimestamps(new ArrayList<Date>(timestamps.length));
        }
        for (Date ele : timestamps) {
            this.timestamps.add(ele);
        }
        return this;
    }

    public ProjectedMetric withTimestamps(Collection<Date> timestamps) {
        this.setTimestamps(timestamps);
        return this;
    }

    public List<Double> getValues() {
        return this.values;
    }

    public void setValues(Collection<Double> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<Double>(values);
    }

    public ProjectedMetric withValues(Double ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<Double>(values.length));
        }
        for (Double ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public ProjectedMetric withValues(Collection<Double> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTimestamps() != null) {
            sb.append("Timestamps: ").append(this.getTimestamps()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectedMetric)) {
            return false;
        }
        ProjectedMetric other = (ProjectedMetric)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTimestamps() == null ^ this.getTimestamps() == null) {
            return false;
        }
        if (other.getTimestamps() != null && !other.getTimestamps().equals(this.getTimestamps())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamps() == null ? 0 : this.getTimestamps().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public ProjectedMetric clone() {
        try {
            return (ProjectedMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectedMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

