/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestarnotifications;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codestarnotifications.AWSCodeStarNotifications;
import com.amazonaws.services.codestarnotifications.AWSCodeStarNotificationsClientBuilder;
import com.amazonaws.services.codestarnotifications.model.AWSCodeStarNotificationsException;
import com.amazonaws.services.codestarnotifications.model.CreateNotificationRuleRequest;
import com.amazonaws.services.codestarnotifications.model.CreateNotificationRuleResult;
import com.amazonaws.services.codestarnotifications.model.DeleteNotificationRuleRequest;
import com.amazonaws.services.codestarnotifications.model.DeleteNotificationRuleResult;
import com.amazonaws.services.codestarnotifications.model.DeleteTargetRequest;
import com.amazonaws.services.codestarnotifications.model.DeleteTargetResult;
import com.amazonaws.services.codestarnotifications.model.DescribeNotificationRuleRequest;
import com.amazonaws.services.codestarnotifications.model.DescribeNotificationRuleResult;
import com.amazonaws.services.codestarnotifications.model.ListEventTypesRequest;
import com.amazonaws.services.codestarnotifications.model.ListEventTypesResult;
import com.amazonaws.services.codestarnotifications.model.ListNotificationRulesRequest;
import com.amazonaws.services.codestarnotifications.model.ListNotificationRulesResult;
import com.amazonaws.services.codestarnotifications.model.ListTagsForResourceRequest;
import com.amazonaws.services.codestarnotifications.model.ListTagsForResourceResult;
import com.amazonaws.services.codestarnotifications.model.ListTargetsRequest;
import com.amazonaws.services.codestarnotifications.model.ListTargetsResult;
import com.amazonaws.services.codestarnotifications.model.SubscribeRequest;
import com.amazonaws.services.codestarnotifications.model.SubscribeResult;
import com.amazonaws.services.codestarnotifications.model.TagResourceRequest;
import com.amazonaws.services.codestarnotifications.model.TagResourceResult;
import com.amazonaws.services.codestarnotifications.model.UnsubscribeRequest;
import com.amazonaws.services.codestarnotifications.model.UnsubscribeResult;
import com.amazonaws.services.codestarnotifications.model.UntagResourceRequest;
import com.amazonaws.services.codestarnotifications.model.UntagResourceResult;
import com.amazonaws.services.codestarnotifications.model.UpdateNotificationRuleRequest;
import com.amazonaws.services.codestarnotifications.model.UpdateNotificationRuleResult;
import com.amazonaws.services.codestarnotifications.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ConcurrentModificationExceptionUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ConfigurationExceptionUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.CreateNotificationRuleRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.CreateNotificationRuleResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.DeleteNotificationRuleRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.DeleteNotificationRuleResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.DeleteTargetRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.DeleteTargetResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.DescribeNotificationRuleRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.DescribeNotificationRuleResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ListEventTypesRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ListEventTypesResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ListNotificationRulesRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ListNotificationRulesResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ListTargetsRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ListTargetsResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ResourceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.SubscribeRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.SubscribeResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.UnsubscribeRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.UnsubscribeResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.UpdateNotificationRuleRequestProtocolMarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.UpdateNotificationRuleResultJsonUnmarshaller;
import com.amazonaws.services.codestarnotifications.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSCodeStarNotificationsClient
extends AmazonWebServiceClient
implements AWSCodeStarNotifications {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCodeStarNotifications.class);
    private static final String DEFAULT_SIGNING_NAME = "codestar-notifications";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withExceptionUnmarshaller(ConcurrentModificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConfigurationException").withExceptionUnmarshaller(ConfigurationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withExceptionUnmarshaller(ResourceAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller(InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller(LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCodeStarNotificationsException.class));

    public static AWSCodeStarNotificationsClientBuilder builder() {
        return AWSCodeStarNotificationsClientBuilder.standard();
    }

    AWSCodeStarNotificationsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCodeStarNotificationsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codestar-notifications.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codestarnotifications/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codestarnotifications/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateNotificationRuleResult createNotificationRule(CreateNotificationRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateNotificationRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateNotificationRuleResult executeCreateNotificationRule(CreateNotificationRuleRequest createNotificationRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createNotificationRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateNotificationRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateNotificationRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createNotificationRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateNotificationRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateNotificationRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateNotificationRuleResult createNotificationRuleResult = (CreateNotificationRuleResult)response.getAwsResponse();
            return createNotificationRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNotificationRuleResult deleteNotificationRule(DeleteNotificationRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteNotificationRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNotificationRuleResult executeDeleteNotificationRule(DeleteNotificationRuleRequest deleteNotificationRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNotificationRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNotificationRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNotificationRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteNotificationRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteNotificationRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteNotificationRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNotificationRuleResult deleteNotificationRuleResult = (DeleteNotificationRuleResult)response.getAwsResponse();
            return deleteNotificationRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTargetResult deleteTarget(DeleteTargetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteTarget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTargetResult executeDeleteTarget(DeleteTargetRequest deleteTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTargetRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteTarget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTargetResult deleteTargetResult = (DeleteTargetResult)response.getAwsResponse();
            return deleteTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeNotificationRuleResult describeNotificationRule(DescribeNotificationRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeNotificationRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeNotificationRuleResult executeDescribeNotificationRule(DescribeNotificationRuleRequest describeNotificationRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNotificationRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeNotificationRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeNotificationRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeNotificationRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeNotificationRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeNotificationRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeNotificationRuleResult describeNotificationRuleResult = (DescribeNotificationRuleResult)response.getAwsResponse();
            return describeNotificationRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEventTypesResult listEventTypes(ListEventTypesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListEventTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEventTypesResult executeListEventTypes(ListEventTypesRequest listEventTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventTypesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listEventTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListEventTypes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListEventTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventTypesResult listEventTypesResult = (ListEventTypesResult)response.getAwsResponse();
            return listEventTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListNotificationRulesResult listNotificationRules(ListNotificationRulesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListNotificationRules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListNotificationRulesResult executeListNotificationRules(ListNotificationRulesRequest listNotificationRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listNotificationRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListNotificationRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListNotificationRulesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listNotificationRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListNotificationRules");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListNotificationRulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListNotificationRulesResult listNotificationRulesResult = (ListNotificationRulesResult)response.getAwsResponse();
            return listNotificationRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTargetsResult listTargets(ListTargetsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTargets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTargetsResult executeListTargets(ListTargetsRequest listTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTargetsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTargets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTargetsResult listTargetsResult = (ListTargetsResult)response.getAwsResponse();
            return listTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SubscribeResult subscribe(SubscribeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSubscribe(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SubscribeResult executeSubscribe(SubscribeRequest subscribeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(subscribeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubscribeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubscribeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(subscribeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "Subscribe");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SubscribeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SubscribeResult subscribeResult = (SubscribeResult)response.getAwsResponse();
            return subscribeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UnsubscribeResult unsubscribe(UnsubscribeRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUnsubscribe(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UnsubscribeResult executeUnsubscribe(UnsubscribeRequest unsubscribeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unsubscribeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnsubscribeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnsubscribeRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(unsubscribeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "Unsubscribe");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UnsubscribeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UnsubscribeResult unsubscribeResult = (UnsubscribeResult)response.getAwsResponse();
            return unsubscribeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateNotificationRuleResult updateNotificationRule(UpdateNotificationRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateNotificationRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateNotificationRuleResult executeUpdateNotificationRule(UpdateNotificationRuleRequest updateNotificationRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateNotificationRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateNotificationRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateNotificationRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateNotificationRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "codestar notifications");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateNotificationRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateNotificationRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateNotificationRuleResult updateNotificationRuleResult = (UpdateNotificationRuleResult)response.getAwsResponse();
            return updateNotificationRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

