/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codegurureviewer.model.ProviderType;
import com.amazonaws.services.codegurureviewer.model.RepositoryAssociationState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRepositoryAssociationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> providerTypes;
    private List<String> states;
    private List<String> names;
    private List<String> owners;
    private Integer maxResults;
    private String nextToken;

    public List<String> getProviderTypes() {
        return this.providerTypes;
    }

    public void setProviderTypes(Collection<String> providerTypes) {
        if (providerTypes == null) {
            this.providerTypes = null;
            return;
        }
        this.providerTypes = new ArrayList<String>(providerTypes);
    }

    public ListRepositoryAssociationsRequest withProviderTypes(String ... providerTypes) {
        if (this.providerTypes == null) {
            this.setProviderTypes(new ArrayList<String>(providerTypes.length));
        }
        for (String ele : providerTypes) {
            this.providerTypes.add(ele);
        }
        return this;
    }

    public ListRepositoryAssociationsRequest withProviderTypes(Collection<String> providerTypes) {
        this.setProviderTypes(providerTypes);
        return this;
    }

    public ListRepositoryAssociationsRequest withProviderTypes(ProviderType ... providerTypes) {
        ArrayList<String> providerTypesCopy = new ArrayList<String>(providerTypes.length);
        for (ProviderType value : providerTypes) {
            providerTypesCopy.add(value.toString());
        }
        if (this.getProviderTypes() == null) {
            this.setProviderTypes(providerTypesCopy);
        } else {
            this.getProviderTypes().addAll(providerTypesCopy);
        }
        return this;
    }

    public List<String> getStates() {
        return this.states;
    }

    public void setStates(Collection<String> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<String>(states);
    }

    public ListRepositoryAssociationsRequest withStates(String ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<String>(states.length));
        }
        for (String ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public ListRepositoryAssociationsRequest withStates(Collection<String> states) {
        this.setStates(states);
        return this;
    }

    public ListRepositoryAssociationsRequest withStates(RepositoryAssociationState ... states) {
        ArrayList<String> statesCopy = new ArrayList<String>(states.length);
        for (RepositoryAssociationState value : states) {
            statesCopy.add(value.toString());
        }
        if (this.getStates() == null) {
            this.setStates(statesCopy);
        } else {
            this.getStates().addAll(statesCopy);
        }
        return this;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(Collection<String> names) {
        if (names == null) {
            this.names = null;
            return;
        }
        this.names = new ArrayList<String>(names);
    }

    public ListRepositoryAssociationsRequest withNames(String ... names) {
        if (this.names == null) {
            this.setNames(new ArrayList<String>(names.length));
        }
        for (String ele : names) {
            this.names.add(ele);
        }
        return this;
    }

    public ListRepositoryAssociationsRequest withNames(Collection<String> names) {
        this.setNames(names);
        return this;
    }

    public List<String> getOwners() {
        return this.owners;
    }

    public void setOwners(Collection<String> owners) {
        if (owners == null) {
            this.owners = null;
            return;
        }
        this.owners = new ArrayList<String>(owners);
    }

    public ListRepositoryAssociationsRequest withOwners(String ... owners) {
        if (this.owners == null) {
            this.setOwners(new ArrayList<String>(owners.length));
        }
        for (String ele : owners) {
            this.owners.add(ele);
        }
        return this;
    }

    public ListRepositoryAssociationsRequest withOwners(Collection<String> owners) {
        this.setOwners(owners);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListRepositoryAssociationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRepositoryAssociationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProviderTypes() != null) {
            sb.append("ProviderTypes: ").append(this.getProviderTypes()).append(",");
        }
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates()).append(",");
        }
        if (this.getNames() != null) {
            sb.append("Names: ").append(this.getNames()).append(",");
        }
        if (this.getOwners() != null) {
            sb.append("Owners: ").append(this.getOwners()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoryAssociationsRequest)) {
            return false;
        }
        ListRepositoryAssociationsRequest other = (ListRepositoryAssociationsRequest)obj;
        if (other.getProviderTypes() == null ^ this.getProviderTypes() == null) {
            return false;
        }
        if (other.getProviderTypes() != null && !other.getProviderTypes().equals(this.getProviderTypes())) {
            return false;
        }
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        if (other.getStates() != null && !other.getStates().equals(this.getStates())) {
            return false;
        }
        if (other.getNames() == null ^ this.getNames() == null) {
            return false;
        }
        if (other.getNames() != null && !other.getNames().equals(this.getNames())) {
            return false;
        }
        if (other.getOwners() == null ^ this.getOwners() == null) {
            return false;
        }
        if (other.getOwners() != null && !other.getOwners().equals(this.getOwners())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProviderTypes() == null ? 0 : this.getProviderTypes().hashCode());
        hashCode = 31 * hashCode + (this.getStates() == null ? 0 : this.getStates().hashCode());
        hashCode = 31 * hashCode + (this.getNames() == null ? 0 : this.getNames().hashCode());
        hashCode = 31 * hashCode + (this.getOwners() == null ? 0 : this.getOwners().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListRepositoryAssociationsRequest clone() {
        return (ListRepositoryAssociationsRequest)super.clone();
    }
}

