/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeguruprofiler;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codeguruprofiler.AmazonCodeGuruProfiler;
import com.amazonaws.services.codeguruprofiler.AmazonCodeGuruProfilerClientBuilder;
import com.amazonaws.services.codeguruprofiler.model.AmazonCodeGuruProfilerException;
import com.amazonaws.services.codeguruprofiler.model.ConfigureAgentRequest;
import com.amazonaws.services.codeguruprofiler.model.ConfigureAgentResult;
import com.amazonaws.services.codeguruprofiler.model.CreateProfilingGroupRequest;
import com.amazonaws.services.codeguruprofiler.model.CreateProfilingGroupResult;
import com.amazonaws.services.codeguruprofiler.model.DeleteProfilingGroupRequest;
import com.amazonaws.services.codeguruprofiler.model.DeleteProfilingGroupResult;
import com.amazonaws.services.codeguruprofiler.model.DescribeProfilingGroupRequest;
import com.amazonaws.services.codeguruprofiler.model.DescribeProfilingGroupResult;
import com.amazonaws.services.codeguruprofiler.model.GetProfileRequest;
import com.amazonaws.services.codeguruprofiler.model.GetProfileResult;
import com.amazonaws.services.codeguruprofiler.model.ListProfileTimesRequest;
import com.amazonaws.services.codeguruprofiler.model.ListProfileTimesResult;
import com.amazonaws.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import com.amazonaws.services.codeguruprofiler.model.ListProfilingGroupsResult;
import com.amazonaws.services.codeguruprofiler.model.PostAgentProfileRequest;
import com.amazonaws.services.codeguruprofiler.model.PostAgentProfileResult;
import com.amazonaws.services.codeguruprofiler.model.UpdateProfilingGroupRequest;
import com.amazonaws.services.codeguruprofiler.model.UpdateProfilingGroupResult;
import com.amazonaws.services.codeguruprofiler.model.transform.ConfigureAgentRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ConfigureAgentResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.CreateProfilingGroupRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.CreateProfilingGroupResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.DeleteProfilingGroupRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.DeleteProfilingGroupResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.DescribeProfilingGroupRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.DescribeProfilingGroupResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetProfileRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.GetProfileResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListProfileTimesRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListProfileTimesResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListProfilingGroupsRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ListProfilingGroupsResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.PostAgentProfileRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.PostAgentProfileResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.UpdateProfilingGroupRequestProtocolMarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.UpdateProfilingGroupResultJsonUnmarshaller;
import com.amazonaws.services.codeguruprofiler.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AmazonCodeGuruProfilerClient
extends AmazonWebServiceClient
implements AmazonCodeGuruProfiler {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCodeGuruProfiler.class);
    private static final String DEFAULT_SIGNING_NAME = "codeguru-profiler";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller(ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller(ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonCodeGuruProfilerException.class));

    public static AmazonCodeGuruProfilerClientBuilder builder() {
        return AmazonCodeGuruProfilerClientBuilder.standard();
    }

    AmazonCodeGuruProfilerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonCodeGuruProfilerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codeguru-profiler.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codeguruprofiler/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codeguruprofiler/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public ConfigureAgentResult configureAgent(ConfigureAgentRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeConfigureAgent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ConfigureAgentResult executeConfigureAgent(ConfigureAgentRequest configureAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(configureAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfigureAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfigureAgentRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(configureAgentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ConfigureAgent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ConfigureAgentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ConfigureAgentResult configureAgentResult = (ConfigureAgentResult)response.getAwsResponse();
            return configureAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProfilingGroupResult createProfilingGroup(CreateProfilingGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateProfilingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProfilingGroupResult executeCreateProfilingGroup(CreateProfilingGroupRequest createProfilingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProfilingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProfilingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProfilingGroupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createProfilingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateProfilingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateProfilingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProfilingGroupResult createProfilingGroupResult = (CreateProfilingGroupResult)response.getAwsResponse();
            return createProfilingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProfilingGroupResult deleteProfilingGroup(DeleteProfilingGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteProfilingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProfilingGroupResult executeDeleteProfilingGroup(DeleteProfilingGroupRequest deleteProfilingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProfilingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProfilingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProfilingGroupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteProfilingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteProfilingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteProfilingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProfilingGroupResult deleteProfilingGroupResult = (DeleteProfilingGroupResult)response.getAwsResponse();
            return deleteProfilingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProfilingGroupResult describeProfilingGroup(DescribeProfilingGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeProfilingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProfilingGroupResult executeDescribeProfilingGroup(DescribeProfilingGroupRequest describeProfilingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProfilingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProfilingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProfilingGroupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeProfilingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeProfilingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeProfilingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProfilingGroupResult describeProfilingGroupResult = (DescribeProfilingGroupResult)response.getAwsResponse();
            return describeProfilingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProfileResult executeGetProfile(GetProfileRequest getProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProfileRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(false), new GetProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProfileResult getProfileResult = (GetProfileResult)response.getAwsResponse();
            return getProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProfileTimesResult listProfileTimes(ListProfileTimesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListProfileTimes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProfileTimesResult executeListProfileTimes(ListProfileTimesRequest listProfileTimesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProfileTimesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProfileTimesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProfileTimesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listProfileTimesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListProfileTimes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListProfileTimesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProfileTimesResult listProfileTimesResult = (ListProfileTimesResult)response.getAwsResponse();
            return listProfileTimesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProfilingGroupsResult listProfilingGroups(ListProfilingGroupsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListProfilingGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProfilingGroupsResult executeListProfilingGroups(ListProfilingGroupsRequest listProfilingGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProfilingGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProfilingGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProfilingGroupsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listProfilingGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListProfilingGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListProfilingGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProfilingGroupsResult listProfilingGroupsResult = (ListProfilingGroupsResult)response.getAwsResponse();
            return listProfilingGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PostAgentProfileResult postAgentProfile(PostAgentProfileRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePostAgentProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PostAgentProfileResult executePostAgentProfile(PostAgentProfileRequest postAgentProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(postAgentProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PostAgentProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PostAgentProfileRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(postAgentProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PostAgentProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PostAgentProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PostAgentProfileResult postAgentProfileResult = (PostAgentProfileResult)response.getAwsResponse();
            return postAgentProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProfilingGroupResult updateProfilingGroup(UpdateProfilingGroupRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateProfilingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProfilingGroupResult executeUpdateProfilingGroup(UpdateProfilingGroupRequest updateProfilingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProfilingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProfilingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProfilingGroupRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateProfilingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "CodeGuruProfiler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateProfilingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateProfilingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProfilingGroupResult updateProfilingGroupResult = (UpdateProfilingGroupResult)response.getAwsResponse();
            return updateProfilingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

