/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appconfig.model.transform;

import com.amazonaws.services.appconfig.model.GetConfigurationResult;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.IOUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class GetConfigurationResultJsonUnmarshaller
implements Unmarshaller<GetConfigurationResult, JsonUnmarshallerContext> {
    private static GetConfigurationResultJsonUnmarshaller instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigurationResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputStream is;
        GetConfigurationResult getConfigurationResult = new GetConfigurationResult();
        if (context.isStartOfDocument()) {
            if (context.getHeader("Configuration-Version") != null) {
                context.setCurrentHeader("Configuration-Version");
                getConfigurationResult.setConfigurationVersion(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                getConfigurationResult.setContentType(context.getUnmarshaller(String.class).unmarshall(context));
            }
        }
        if ((is = context.getHttpResponse().getContent()) != null) {
            try {
                getConfigurationResult.setContent(ByteBuffer.wrap(IOUtils.toByteArray(is)));
            }
            finally {
                IOUtils.closeQuietly(is, null);
            }
        }
        return getConfigurationResult;
    }

    public static GetConfigurationResultJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new GetConfigurationResultJsonUnmarshaller();
        }
        return instance;
    }
}

