/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.accessanalyzer.model.InlineArchiveRule;
import com.amazonaws.services.accessanalyzer.model.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAnalyzerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String analyzerName;
    private List<InlineArchiveRule> archiveRules;
    private String clientToken;
    private Map<String, String> tags;
    private String type;

    public void setAnalyzerName(String analyzerName) {
        this.analyzerName = analyzerName;
    }

    public String getAnalyzerName() {
        return this.analyzerName;
    }

    public CreateAnalyzerRequest withAnalyzerName(String analyzerName) {
        this.setAnalyzerName(analyzerName);
        return this;
    }

    public List<InlineArchiveRule> getArchiveRules() {
        return this.archiveRules;
    }

    public void setArchiveRules(Collection<InlineArchiveRule> archiveRules) {
        if (archiveRules == null) {
            this.archiveRules = null;
            return;
        }
        this.archiveRules = new ArrayList<InlineArchiveRule>(archiveRules);
    }

    public CreateAnalyzerRequest withArchiveRules(InlineArchiveRule ... archiveRules) {
        if (this.archiveRules == null) {
            this.setArchiveRules(new ArrayList<InlineArchiveRule>(archiveRules.length));
        }
        for (InlineArchiveRule ele : archiveRules) {
            this.archiveRules.add(ele);
        }
        return this;
    }

    public CreateAnalyzerRequest withArchiveRules(Collection<InlineArchiveRule> archiveRules) {
        this.setArchiveRules(archiveRules);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateAnalyzerRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateAnalyzerRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateAnalyzerRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateAnalyzerRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateAnalyzerRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateAnalyzerRequest withType(Type type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnalyzerName() != null) {
            sb.append("AnalyzerName: ").append(this.getAnalyzerName()).append(",");
        }
        if (this.getArchiveRules() != null) {
            sb.append("ArchiveRules: ").append(this.getArchiveRules()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalyzerRequest)) {
            return false;
        }
        CreateAnalyzerRequest other = (CreateAnalyzerRequest)obj;
        if (other.getAnalyzerName() == null ^ this.getAnalyzerName() == null) {
            return false;
        }
        if (other.getAnalyzerName() != null && !other.getAnalyzerName().equals(this.getAnalyzerName())) {
            return false;
        }
        if (other.getArchiveRules() == null ^ this.getArchiveRules() == null) {
            return false;
        }
        if (other.getArchiveRules() != null && !other.getArchiveRules().equals(this.getArchiveRules())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnalyzerName() == null ? 0 : this.getAnalyzerName().hashCode());
        hashCode = 31 * hashCode + (this.getArchiveRules() == null ? 0 : this.getArchiveRules().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    @Override
    public CreateAnalyzerRequest clone() {
        return (CreateAnalyzerRequest)super.clone();
    }
}

