/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.accessanalyzer.AWSAccessAnalyzer;
import com.amazonaws.services.accessanalyzer.AWSAccessAnalyzerClientBuilder;
import com.amazonaws.services.accessanalyzer.model.AWSAccessAnalyzerException;
import com.amazonaws.services.accessanalyzer.model.CreateAnalyzerRequest;
import com.amazonaws.services.accessanalyzer.model.CreateAnalyzerResult;
import com.amazonaws.services.accessanalyzer.model.CreateArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.CreateArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.DeleteAnalyzerRequest;
import com.amazonaws.services.accessanalyzer.model.DeleteAnalyzerResult;
import com.amazonaws.services.accessanalyzer.model.DeleteArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.DeleteArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.GetAnalyzedResourceRequest;
import com.amazonaws.services.accessanalyzer.model.GetAnalyzedResourceResult;
import com.amazonaws.services.accessanalyzer.model.GetAnalyzerRequest;
import com.amazonaws.services.accessanalyzer.model.GetAnalyzerResult;
import com.amazonaws.services.accessanalyzer.model.GetArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.GetArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.GetFindingRequest;
import com.amazonaws.services.accessanalyzer.model.GetFindingResult;
import com.amazonaws.services.accessanalyzer.model.ListAnalyzedResourcesRequest;
import com.amazonaws.services.accessanalyzer.model.ListAnalyzedResourcesResult;
import com.amazonaws.services.accessanalyzer.model.ListAnalyzersRequest;
import com.amazonaws.services.accessanalyzer.model.ListAnalyzersResult;
import com.amazonaws.services.accessanalyzer.model.ListArchiveRulesRequest;
import com.amazonaws.services.accessanalyzer.model.ListArchiveRulesResult;
import com.amazonaws.services.accessanalyzer.model.ListFindingsRequest;
import com.amazonaws.services.accessanalyzer.model.ListFindingsResult;
import com.amazonaws.services.accessanalyzer.model.ListTagsForResourceRequest;
import com.amazonaws.services.accessanalyzer.model.ListTagsForResourceResult;
import com.amazonaws.services.accessanalyzer.model.StartResourceScanRequest;
import com.amazonaws.services.accessanalyzer.model.StartResourceScanResult;
import com.amazonaws.services.accessanalyzer.model.TagResourceRequest;
import com.amazonaws.services.accessanalyzer.model.TagResourceResult;
import com.amazonaws.services.accessanalyzer.model.UntagResourceRequest;
import com.amazonaws.services.accessanalyzer.model.UntagResourceResult;
import com.amazonaws.services.accessanalyzer.model.UpdateArchiveRuleRequest;
import com.amazonaws.services.accessanalyzer.model.UpdateArchiveRuleResult;
import com.amazonaws.services.accessanalyzer.model.UpdateFindingsRequest;
import com.amazonaws.services.accessanalyzer.model.UpdateFindingsResult;
import com.amazonaws.services.accessanalyzer.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.CreateAnalyzerRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.CreateAnalyzerResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.CreateArchiveRuleRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.CreateArchiveRuleResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.DeleteAnalyzerRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.DeleteAnalyzerResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.DeleteArchiveRuleRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.DeleteArchiveRuleResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.GetAnalyzedResourceRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.GetAnalyzedResourceResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.GetAnalyzerRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.GetAnalyzerResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.GetArchiveRuleRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.GetArchiveRuleResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.GetFindingRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.GetFindingResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListAnalyzedResourcesRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListAnalyzedResourcesResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListAnalyzersRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListAnalyzersResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListArchiveRulesRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListArchiveRulesResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListFindingsRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListFindingsResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.StartResourceScanRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.StartResourceScanResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.UpdateArchiveRuleRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.UpdateArchiveRuleResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.UpdateFindingsRequestProtocolMarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.UpdateFindingsResultJsonUnmarshaller;
import com.amazonaws.services.accessanalyzer.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSAccessAnalyzerClient
extends AmazonWebServiceClient
implements AWSAccessAnalyzer {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSAccessAnalyzer.class);
    private static final String DEFAULT_SIGNING_NAME = "access-analyzer";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller(ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller(ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSAccessAnalyzerException.class));

    public static AWSAccessAnalyzerClientBuilder builder() {
        return AWSAccessAnalyzerClientBuilder.standard();
    }

    AWSAccessAnalyzerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSAccessAnalyzerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("access-analyzer.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/accessanalyzer/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/accessanalyzer/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateAnalyzerResult createAnalyzer(CreateAnalyzerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateAnalyzer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAnalyzerResult executeCreateAnalyzer(CreateAnalyzerRequest createAnalyzerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAnalyzerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAnalyzerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAnalyzerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createAnalyzerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateAnalyzer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateAnalyzerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAnalyzerResult createAnalyzerResult = (CreateAnalyzerResult)response.getAwsResponse();
            return createAnalyzerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateArchiveRuleResult createArchiveRule(CreateArchiveRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateArchiveRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateArchiveRuleResult executeCreateArchiveRule(CreateArchiveRuleRequest createArchiveRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createArchiveRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateArchiveRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateArchiveRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createArchiveRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateArchiveRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateArchiveRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateArchiveRuleResult createArchiveRuleResult = (CreateArchiveRuleResult)response.getAwsResponse();
            return createArchiveRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAnalyzerResult deleteAnalyzer(DeleteAnalyzerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteAnalyzer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAnalyzerResult executeDeleteAnalyzer(DeleteAnalyzerRequest deleteAnalyzerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAnalyzerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAnalyzerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAnalyzerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteAnalyzerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteAnalyzer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteAnalyzerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAnalyzerResult deleteAnalyzerResult = (DeleteAnalyzerResult)response.getAwsResponse();
            return deleteAnalyzerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteArchiveRuleResult deleteArchiveRule(DeleteArchiveRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteArchiveRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteArchiveRuleResult executeDeleteArchiveRule(DeleteArchiveRuleRequest deleteArchiveRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteArchiveRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteArchiveRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteArchiveRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteArchiveRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteArchiveRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteArchiveRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteArchiveRuleResult deleteArchiveRuleResult = (DeleteArchiveRuleResult)response.getAwsResponse();
            return deleteArchiveRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAnalyzedResourceResult getAnalyzedResource(GetAnalyzedResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetAnalyzedResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAnalyzedResourceResult executeGetAnalyzedResource(GetAnalyzedResourceRequest getAnalyzedResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAnalyzedResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAnalyzedResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAnalyzedResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getAnalyzedResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetAnalyzedResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetAnalyzedResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAnalyzedResourceResult getAnalyzedResourceResult = (GetAnalyzedResourceResult)response.getAwsResponse();
            return getAnalyzedResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAnalyzerResult getAnalyzer(GetAnalyzerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetAnalyzer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAnalyzerResult executeGetAnalyzer(GetAnalyzerRequest getAnalyzerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAnalyzerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAnalyzerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAnalyzerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getAnalyzerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetAnalyzer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetAnalyzerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAnalyzerResult getAnalyzerResult = (GetAnalyzerResult)response.getAwsResponse();
            return getAnalyzerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetArchiveRuleResult getArchiveRule(GetArchiveRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetArchiveRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetArchiveRuleResult executeGetArchiveRule(GetArchiveRuleRequest getArchiveRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getArchiveRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetArchiveRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetArchiveRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getArchiveRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetArchiveRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetArchiveRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetArchiveRuleResult getArchiveRuleResult = (GetArchiveRuleResult)response.getAwsResponse();
            return getArchiveRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFindingResult getFinding(GetFindingRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetFinding(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFindingResult executeGetFinding(GetFindingRequest getFindingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFindingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFindingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFindingRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getFindingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetFinding");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetFindingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFindingResult getFindingResult = (GetFindingResult)response.getAwsResponse();
            return getFindingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAnalyzedResourcesResult listAnalyzedResources(ListAnalyzedResourcesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListAnalyzedResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAnalyzedResourcesResult executeListAnalyzedResources(ListAnalyzedResourcesRequest listAnalyzedResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAnalyzedResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAnalyzedResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAnalyzedResourcesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listAnalyzedResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListAnalyzedResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListAnalyzedResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAnalyzedResourcesResult listAnalyzedResourcesResult = (ListAnalyzedResourcesResult)response.getAwsResponse();
            return listAnalyzedResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAnalyzersResult listAnalyzers(ListAnalyzersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListAnalyzers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAnalyzersResult executeListAnalyzers(ListAnalyzersRequest listAnalyzersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAnalyzersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAnalyzersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAnalyzersRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listAnalyzersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListAnalyzers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListAnalyzersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAnalyzersResult listAnalyzersResult = (ListAnalyzersResult)response.getAwsResponse();
            return listAnalyzersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListArchiveRulesResult listArchiveRules(ListArchiveRulesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListArchiveRules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListArchiveRulesResult executeListArchiveRules(ListArchiveRulesRequest listArchiveRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listArchiveRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListArchiveRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListArchiveRulesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listArchiveRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListArchiveRules");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListArchiveRulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListArchiveRulesResult listArchiveRulesResult = (ListArchiveRulesResult)response.getAwsResponse();
            return listArchiveRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFindingsResult listFindings(ListFindingsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListFindings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFindingsResult executeListFindings(ListFindingsRequest listFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFindingsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListFindings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFindingsResult listFindingsResult = (ListFindingsResult)response.getAwsResponse();
            return listFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartResourceScanResult startResourceScan(StartResourceScanRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartResourceScan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartResourceScanResult executeStartResourceScan(StartResourceScanRequest startResourceScanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startResourceScanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartResourceScanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartResourceScanRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startResourceScanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "StartResourceScan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartResourceScanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartResourceScanResult startResourceScanResult = (StartResourceScanResult)response.getAwsResponse();
            return startResourceScanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateArchiveRuleResult updateArchiveRule(UpdateArchiveRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateArchiveRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateArchiveRuleResult executeUpdateArchiveRule(UpdateArchiveRuleRequest updateArchiveRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateArchiveRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateArchiveRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateArchiveRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateArchiveRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateArchiveRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateArchiveRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateArchiveRuleResult updateArchiveRuleResult = (UpdateArchiveRuleResult)response.getAwsResponse();
            return updateArchiveRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateFindingsResult updateFindings(UpdateFindingsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateFindings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateFindingsResult executeUpdateFindings(UpdateFindingsRequest updateFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateFindingsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "AccessAnalyzer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateFindings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateFindingsResult updateFindingsResult = (UpdateFindingsResult)response.getAwsResponse();
            return updateFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

