/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.S3Object;
import com.amazonaws.services.textract.model.transform.DocumentMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Document
implements Serializable,
Cloneable,
StructuredPojo {
    private ByteBuffer bytes;
    private S3Object s3Object;

    public void setBytes(ByteBuffer bytes) {
        this.bytes = bytes;
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public Document withBytes(ByteBuffer bytes) {
        this.setBytes(bytes);
        return this;
    }

    public void setS3Object(S3Object s3Object) {
        this.s3Object = s3Object;
    }

    public S3Object getS3Object() {
        return this.s3Object;
    }

    public Document withS3Object(S3Object s3Object) {
        this.setS3Object(s3Object);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBytes() != null) {
            sb.append("Bytes: ").append(this.getBytes()).append(",");
        }
        if (this.getS3Object() != null) {
            sb.append("S3Object: ").append(this.getS3Object());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document)obj;
        if (other.getBytes() == null ^ this.getBytes() == null) {
            return false;
        }
        if (other.getBytes() != null && !other.getBytes().equals(this.getBytes())) {
            return false;
        }
        if (other.getS3Object() == null ^ this.getS3Object() == null) {
            return false;
        }
        return other.getS3Object() == null || other.getS3Object().equals(this.getS3Object());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBytes() == null ? 0 : this.getBytes().hashCode());
        hashCode = 31 * hashCode + (this.getS3Object() == null ? 0 : this.getS3Object().hashCode());
        return hashCode;
    }

    public Document clone() {
        try {
            return (Document)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

