/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.BlockType;
import com.amazonaws.services.textract.model.EntityType;
import com.amazonaws.services.textract.model.Geometry;
import com.amazonaws.services.textract.model.Relationship;
import com.amazonaws.services.textract.model.SelectionStatus;
import com.amazonaws.services.textract.model.transform.BlockMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Block
implements Serializable,
Cloneable,
StructuredPojo {
    private String blockType;
    private Float confidence;
    private String text;
    private Integer rowIndex;
    private Integer columnIndex;
    private Integer rowSpan;
    private Integer columnSpan;
    private Geometry geometry;
    private String id;
    private List<Relationship> relationships;
    private List<String> entityTypes;
    private String selectionStatus;
    private Integer page;

    public void setBlockType(String blockType) {
        this.blockType = blockType;
    }

    public String getBlockType() {
        return this.blockType;
    }

    public Block withBlockType(String blockType) {
        this.setBlockType(blockType);
        return this;
    }

    public Block withBlockType(BlockType blockType) {
        this.blockType = blockType.toString();
        return this;
    }

    public void setConfidence(Float confidence) {
        this.confidence = confidence;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public Block withConfidence(Float confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Block withText(String text) {
        this.setText(text);
        return this;
    }

    public void setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
    }

    public Integer getRowIndex() {
        return this.rowIndex;
    }

    public Block withRowIndex(Integer rowIndex) {
        this.setRowIndex(rowIndex);
        return this;
    }

    public void setColumnIndex(Integer columnIndex) {
        this.columnIndex = columnIndex;
    }

    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    public Block withColumnIndex(Integer columnIndex) {
        this.setColumnIndex(columnIndex);
        return this;
    }

    public void setRowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
    }

    public Integer getRowSpan() {
        return this.rowSpan;
    }

    public Block withRowSpan(Integer rowSpan) {
        this.setRowSpan(rowSpan);
        return this;
    }

    public void setColumnSpan(Integer columnSpan) {
        this.columnSpan = columnSpan;
    }

    public Integer getColumnSpan() {
        return this.columnSpan;
    }

    public Block withColumnSpan(Integer columnSpan) {
        this.setColumnSpan(columnSpan);
        return this;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public Block withGeometry(Geometry geometry) {
        this.setGeometry(geometry);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Block withId(String id) {
        this.setId(id);
        return this;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(Collection<Relationship> relationships) {
        if (relationships == null) {
            this.relationships = null;
            return;
        }
        this.relationships = new ArrayList<Relationship>(relationships);
    }

    public Block withRelationships(Relationship ... relationships) {
        if (this.relationships == null) {
            this.setRelationships(new ArrayList<Relationship>(relationships.length));
        }
        for (Relationship ele : relationships) {
            this.relationships.add(ele);
        }
        return this;
    }

    public Block withRelationships(Collection<Relationship> relationships) {
        this.setRelationships(relationships);
        return this;
    }

    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Collection<String> entityTypes) {
        if (entityTypes == null) {
            this.entityTypes = null;
            return;
        }
        this.entityTypes = new ArrayList<String>(entityTypes);
    }

    public Block withEntityTypes(String ... entityTypes) {
        if (this.entityTypes == null) {
            this.setEntityTypes(new ArrayList<String>(entityTypes.length));
        }
        for (String ele : entityTypes) {
            this.entityTypes.add(ele);
        }
        return this;
    }

    public Block withEntityTypes(Collection<String> entityTypes) {
        this.setEntityTypes(entityTypes);
        return this;
    }

    public Block withEntityTypes(EntityType ... entityTypes) {
        ArrayList<String> entityTypesCopy = new ArrayList<String>(entityTypes.length);
        for (EntityType value : entityTypes) {
            entityTypesCopy.add(value.toString());
        }
        if (this.getEntityTypes() == null) {
            this.setEntityTypes(entityTypesCopy);
        } else {
            this.getEntityTypes().addAll(entityTypesCopy);
        }
        return this;
    }

    public void setSelectionStatus(String selectionStatus) {
        this.selectionStatus = selectionStatus;
    }

    public String getSelectionStatus() {
        return this.selectionStatus;
    }

    public Block withSelectionStatus(String selectionStatus) {
        this.setSelectionStatus(selectionStatus);
        return this;
    }

    public Block withSelectionStatus(SelectionStatus selectionStatus) {
        this.selectionStatus = selectionStatus.toString();
        return this;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPage() {
        return this.page;
    }

    public Block withPage(Integer page) {
        this.setPage(page);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlockType() != null) {
            sb.append("BlockType: ").append(this.getBlockType()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getRowIndex() != null) {
            sb.append("RowIndex: ").append(this.getRowIndex()).append(",");
        }
        if (this.getColumnIndex() != null) {
            sb.append("ColumnIndex: ").append(this.getColumnIndex()).append(",");
        }
        if (this.getRowSpan() != null) {
            sb.append("RowSpan: ").append(this.getRowSpan()).append(",");
        }
        if (this.getColumnSpan() != null) {
            sb.append("ColumnSpan: ").append(this.getColumnSpan()).append(",");
        }
        if (this.getGeometry() != null) {
            sb.append("Geometry: ").append(this.getGeometry()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getRelationships() != null) {
            sb.append("Relationships: ").append(this.getRelationships()).append(",");
        }
        if (this.getEntityTypes() != null) {
            sb.append("EntityTypes: ").append(this.getEntityTypes()).append(",");
        }
        if (this.getSelectionStatus() != null) {
            sb.append("SelectionStatus: ").append(this.getSelectionStatus()).append(",");
        }
        if (this.getPage() != null) {
            sb.append("Page: ").append(this.getPage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        if (other.getBlockType() == null ^ this.getBlockType() == null) {
            return false;
        }
        if (other.getBlockType() != null && !other.getBlockType().equals(this.getBlockType())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getRowIndex() == null ^ this.getRowIndex() == null) {
            return false;
        }
        if (other.getRowIndex() != null && !other.getRowIndex().equals(this.getRowIndex())) {
            return false;
        }
        if (other.getColumnIndex() == null ^ this.getColumnIndex() == null) {
            return false;
        }
        if (other.getColumnIndex() != null && !other.getColumnIndex().equals(this.getColumnIndex())) {
            return false;
        }
        if (other.getRowSpan() == null ^ this.getRowSpan() == null) {
            return false;
        }
        if (other.getRowSpan() != null && !other.getRowSpan().equals(this.getRowSpan())) {
            return false;
        }
        if (other.getColumnSpan() == null ^ this.getColumnSpan() == null) {
            return false;
        }
        if (other.getColumnSpan() != null && !other.getColumnSpan().equals(this.getColumnSpan())) {
            return false;
        }
        if (other.getGeometry() == null ^ this.getGeometry() == null) {
            return false;
        }
        if (other.getGeometry() != null && !other.getGeometry().equals(this.getGeometry())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getRelationships() == null ^ this.getRelationships() == null) {
            return false;
        }
        if (other.getRelationships() != null && !other.getRelationships().equals(this.getRelationships())) {
            return false;
        }
        if (other.getEntityTypes() == null ^ this.getEntityTypes() == null) {
            return false;
        }
        if (other.getEntityTypes() != null && !other.getEntityTypes().equals(this.getEntityTypes())) {
            return false;
        }
        if (other.getSelectionStatus() == null ^ this.getSelectionStatus() == null) {
            return false;
        }
        if (other.getSelectionStatus() != null && !other.getSelectionStatus().equals(this.getSelectionStatus())) {
            return false;
        }
        if (other.getPage() == null ^ this.getPage() == null) {
            return false;
        }
        return other.getPage() == null || other.getPage().equals(this.getPage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlockType() == null ? 0 : this.getBlockType().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getRowIndex() == null ? 0 : this.getRowIndex().hashCode());
        hashCode = 31 * hashCode + (this.getColumnIndex() == null ? 0 : this.getColumnIndex().hashCode());
        hashCode = 31 * hashCode + (this.getRowSpan() == null ? 0 : this.getRowSpan().hashCode());
        hashCode = 31 * hashCode + (this.getColumnSpan() == null ? 0 : this.getColumnSpan().hashCode());
        hashCode = 31 * hashCode + (this.getGeometry() == null ? 0 : this.getGeometry().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getRelationships() == null ? 0 : this.getRelationships().hashCode());
        hashCode = 31 * hashCode + (this.getEntityTypes() == null ? 0 : this.getEntityTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSelectionStatus() == null ? 0 : this.getSelectionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPage() == null ? 0 : this.getPage().hashCode());
        return hashCode;
    }

    public Block clone() {
        try {
            return (Block)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

