/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.signer.model.S3Destination;

@SdkInternalApi
public class S3DestinationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").build();
    private static final S3DestinationMarshaller instance = new S3DestinationMarshaller();

    public static S3DestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Destination s3Destination, ProtocolMarshaller protocolMarshaller) {
        if (s3Destination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3Destination.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall(s3Destination.getPrefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

