/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.HttpInstanceSummary;
import java.util.Map;

@SdkInternalApi
public class HttpInstanceSummaryMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> NAMESPACENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamespaceName").build();
    private static final MarshallingInfo<String> SERVICENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceName").build();
    private static final MarshallingInfo<String> HEALTHSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HealthStatus").build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").build();
    private static final HttpInstanceSummaryMarshaller instance = new HttpInstanceSummaryMarshaller();

    public static HttpInstanceSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(HttpInstanceSummary httpInstanceSummary, ProtocolMarshaller protocolMarshaller) {
        if (httpInstanceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(httpInstanceSummary.getInstanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(httpInstanceSummary.getNamespaceName(), NAMESPACENAME_BINDING);
            protocolMarshaller.marshall(httpInstanceSummary.getServiceName(), SERVICENAME_BINDING);
            protocolMarshaller.marshall(httpInstanceSummary.getHealthStatus(), HEALTHSTATUS_BINDING);
            protocolMarshaller.marshall(httpInstanceSummary.getAttributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

