/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servicediscovery.model.HealthStatus;
import com.amazonaws.services.servicediscovery.model.transform.HttpInstanceSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HttpInstanceSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceId;
    private String namespaceName;
    private String serviceName;
    private String healthStatus;
    private Map<String, String> attributes;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public HttpInstanceSummary withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public HttpInstanceSummary withNamespaceName(String namespaceName) {
        this.setNamespaceName(namespaceName);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public HttpInstanceSummary withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public HttpInstanceSummary withHealthStatus(String healthStatus) {
        this.setHealthStatus(healthStatus);
        return this;
    }

    public HttpInstanceSummary withHealthStatus(HealthStatus healthStatus) {
        this.healthStatus = healthStatus.toString();
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public HttpInstanceSummary withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public HttpInstanceSummary addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public HttpInstanceSummary clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getNamespaceName() != null) {
            sb.append("NamespaceName: ").append(this.getNamespaceName()).append(",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getHealthStatus() != null) {
            sb.append("HealthStatus: ").append(this.getHealthStatus()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpInstanceSummary)) {
            return false;
        }
        HttpInstanceSummary other = (HttpInstanceSummary)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getNamespaceName() == null ^ this.getNamespaceName() == null) {
            return false;
        }
        if (other.getNamespaceName() != null && !other.getNamespaceName().equals(this.getNamespaceName())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getHealthStatus() == null ^ this.getHealthStatus() == null) {
            return false;
        }
        if (other.getHealthStatus() != null && !other.getHealthStatus().equals(this.getHealthStatus())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getNamespaceName() == null ? 0 : this.getNamespaceName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getHealthStatus() == null ? 0 : this.getHealthStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public HttpInstanceSummary clone() {
        try {
            return (HttpInstanceSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpInstanceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

