/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.sagemaker.model.DescribeEndpointResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class EndpointInService {
    EndpointInService() {
    }

    static class IsValidationExceptionMatcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        IsValidationExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ValidationException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        @Override
        public boolean matches(DescribeEndpointResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("EndpointStatus");
        }
    }

    static class IsInServiceMatcher
    extends WaiterAcceptor<DescribeEndpointResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsInServiceMatcher() {
        }

        @Override
        public boolean matches(DescribeEndpointResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"InService\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("EndpointStatus");
        }
    }
}

