/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.UpdateJobStatusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class UpdateJobStatusRequestMarshaller
implements Marshaller<Request<UpdateJobStatusRequest>, UpdateJobStatusRequest> {
    @Override
    public Request<UpdateJobStatusRequest> marshall(UpdateJobStatusRequest updateJobStatusRequest) {
        if (updateJobStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateJobStatusRequest> request = new DefaultRequest<UpdateJobStatusRequest>(updateJobStatusRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateJobStatusRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString(updateJobStatusRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/jobs/{id}/status";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "id", updateJobStatusRequest.getJobId());
        request.setResourcePath(uriResourcePath);
        if (updateJobStatusRequest.getRequestedJobStatus() != null) {
            request.addParameter("requestedJobStatus", StringUtils.fromString(updateJobStatusRequest.getRequestedJobStatus()));
        }
        if (updateJobStatusRequest.getStatusUpdateReason() != null) {
            request.addParameter("statusUpdateReason", StringUtils.fromString(updateJobStatusRequest.getStatusUpdateReason()));
        }
        return request;
    }
}

