/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.S3Grantee;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class S3GranteeStaxUnmarshaller
implements Unmarshaller<S3Grantee, StaxUnmarshallerContext> {
    private static S3GranteeStaxUnmarshaller instance;

    @Override
    public S3Grantee unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Grantee s3Grantee = new S3Grantee();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Grantee;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TypeIdentifier", targetDepth)) {
                    s3Grantee.setTypeIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Identifier", targetDepth)) {
                    s3Grantee.setIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DisplayName", targetDepth)) continue;
                s3Grantee.setDisplayName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Grantee;
    }

    public static S3GranteeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3GranteeStaxUnmarshaller();
        }
        return instance;
    }
}

