/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.S3Grant;
import com.amazonaws.services.s3control.model.transform.S3GranteeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class S3GrantStaxUnmarshaller
implements Unmarshaller<S3Grant, StaxUnmarshallerContext> {
    private static S3GrantStaxUnmarshaller instance;

    @Override
    public S3Grant unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Grant s3Grant = new S3Grant();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Grant;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Grantee", targetDepth)) {
                    s3Grant.setGrantee(S3GranteeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Permission", targetDepth)) continue;
                s3Grant.setPermission(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Grant;
    }

    public static S3GrantStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3GrantStaxUnmarshaller();
        }
        return instance;
    }
}

