/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.S3AccessControlPolicy;
import com.amazonaws.services.s3control.model.transform.S3AccessControlListStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class S3AccessControlPolicyStaxUnmarshaller
implements Unmarshaller<S3AccessControlPolicy, StaxUnmarshallerContext> {
    private static S3AccessControlPolicyStaxUnmarshaller instance;

    @Override
    public S3AccessControlPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3AccessControlPolicy s3AccessControlPolicy = new S3AccessControlPolicy();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3AccessControlPolicy;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AccessControlList", targetDepth)) {
                    s3AccessControlPolicy.setAccessControlList(S3AccessControlListStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CannedAccessControlList", targetDepth)) continue;
                s3AccessControlPolicy.setCannedAccessControlList(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3AccessControlPolicy;
    }

    public static S3AccessControlPolicyStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3AccessControlPolicyStaxUnmarshaller();
        }
        return instance;
    }
}

