/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.PublicAccessBlockConfiguration;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class PutPublicAccessBlockRequestMarshaller
implements Marshaller<Request<PutPublicAccessBlockRequest>, PutPublicAccessBlockRequest> {
    @Override
    public Request<PutPublicAccessBlockRequest> marshall(PutPublicAccessBlockRequest putPublicAccessBlockRequest) {
        if (putPublicAccessBlockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutPublicAccessBlockRequest> request = new DefaultRequest<PutPublicAccessBlockRequest>(putPublicAccessBlockRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putPublicAccessBlockRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString(putPublicAccessBlockRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/configuration/publicAccessBlock";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            PublicAccessBlockConfiguration publicAccessBlockConfiguration = putPublicAccessBlockRequest.getPublicAccessBlockConfiguration();
            if (publicAccessBlockConfiguration != null) {
                xmlWriter.startElement("PublicAccessBlockConfiguration");
                if (publicAccessBlockConfiguration.getBlockPublicAcls() != null) {
                    xmlWriter.startElement("BlockPublicAcls").value(publicAccessBlockConfiguration.getBlockPublicAcls()).endElement();
                }
                if (publicAccessBlockConfiguration.getIgnorePublicAcls() != null) {
                    xmlWriter.startElement("IgnorePublicAcls").value(publicAccessBlockConfiguration.getIgnorePublicAcls()).endElement();
                }
                if (publicAccessBlockConfiguration.getBlockPublicPolicy() != null) {
                    xmlWriter.startElement("BlockPublicPolicy").value(publicAccessBlockConfiguration.getBlockPublicPolicy()).endElement();
                }
                if (publicAccessBlockConfiguration.getRestrictPublicBuckets() != null) {
                    xmlWriter.startElement("RestrictPublicBuckets").value(publicAccessBlockConfiguration.getRestrictPublicBuckets()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

