/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.PublicAccessBlockConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PublicAccessBlockConfigurationStaxUnmarshaller
implements Unmarshaller<PublicAccessBlockConfiguration, StaxUnmarshallerContext> {
    private static PublicAccessBlockConfigurationStaxUnmarshaller instance;

    @Override
    public PublicAccessBlockConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        PublicAccessBlockConfiguration publicAccessBlockConfiguration = new PublicAccessBlockConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return publicAccessBlockConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("BlockPublicAcls", targetDepth)) {
                    publicAccessBlockConfiguration.setBlockPublicAcls(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IgnorePublicAcls", targetDepth)) {
                    publicAccessBlockConfiguration.setIgnorePublicAcls(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BlockPublicPolicy", targetDepth)) {
                    publicAccessBlockConfiguration.setBlockPublicPolicy(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("RestrictPublicBuckets", targetDepth)) continue;
                publicAccessBlockConfiguration.setRestrictPublicBuckets(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return publicAccessBlockConfiguration;
    }

    public static PublicAccessBlockConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PublicAccessBlockConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

