/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.ListJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListJobsRequestMarshaller
implements Marshaller<Request<ListJobsRequest>, ListJobsRequest> {
    @Override
    public Request<ListJobsRequest> marshall(ListJobsRequest listJobsRequest) {
        if (listJobsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListJobsRequest> request = new DefaultRequest<ListJobsRequest>(listJobsRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (listJobsRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString(listJobsRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/jobs";
        request.setResourcePath(uriResourcePath);
        if (listJobsRequest.getJobStatuses() != null && !listJobsRequest.getJobStatuses().isEmpty()) {
            for (String value : listJobsRequest.getJobStatuses()) {
                request.addParameter("jobStatuses", StringUtils.fromString(value));
            }
        }
        if (listJobsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString(listJobsRequest.getNextToken()));
        }
        if (listJobsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger(listJobsRequest.getMaxResults()));
        }
        return request;
    }
}

