/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.JobDescriptor;
import com.amazonaws.services.s3control.model.JobFailure;
import com.amazonaws.services.s3control.model.transform.JobFailureStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.JobManifestStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.JobOperationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.JobProgressSummaryStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.JobReportStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class JobDescriptorStaxUnmarshaller
implements Unmarshaller<JobDescriptor, StaxUnmarshallerContext> {
    private static JobDescriptorStaxUnmarshaller instance;

    @Override
    public JobDescriptor unmarshall(StaxUnmarshallerContext context) throws Exception {
        JobDescriptor jobDescriptor = new JobDescriptor();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return jobDescriptor;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("JobId", targetDepth)) {
                    jobDescriptor.setJobId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConfirmationRequired", targetDepth)) {
                    jobDescriptor.setConfirmationRequired(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    jobDescriptor.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("JobArn", targetDepth)) {
                    jobDescriptor.setJobArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    jobDescriptor.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Manifest", targetDepth)) {
                    jobDescriptor.setManifest(JobManifestStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Operation", targetDepth)) {
                    jobDescriptor.setOperation(JobOperationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Priority", targetDepth)) {
                    jobDescriptor.setPriority(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProgressSummary", targetDepth)) {
                    jobDescriptor.setProgressSummary(JobProgressSummaryStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatusUpdateReason", targetDepth)) {
                    jobDescriptor.setStatusUpdateReason(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FailureReasons", targetDepth)) {
                    jobDescriptor.withFailureReasons(new ArrayList<JobFailure>());
                    continue;
                }
                if (context.testExpression("FailureReasons/member", targetDepth)) {
                    jobDescriptor.withFailureReasons(JobFailureStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Report", targetDepth)) {
                    jobDescriptor.setReport(JobReportStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    jobDescriptor.setCreationTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("TerminationDate", targetDepth)) {
                    jobDescriptor.setTerminationDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    jobDescriptor.setRoleArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SuspendedDate", targetDepth)) {
                    jobDescriptor.setSuspendedDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SuspendedCause", targetDepth)) continue;
                jobDescriptor.setSuspendedCause(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return jobDescriptor;
    }

    public static JobDescriptorStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new JobDescriptorStaxUnmarshaller();
        }
        return instance;
    }
}

