/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetPublicAccessBlockRequestMarshaller
implements Marshaller<Request<GetPublicAccessBlockRequest>, GetPublicAccessBlockRequest> {
    @Override
    public Request<GetPublicAccessBlockRequest> marshall(GetPublicAccessBlockRequest getPublicAccessBlockRequest) {
        if (getPublicAccessBlockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetPublicAccessBlockRequest> request = new DefaultRequest<GetPublicAccessBlockRequest>(getPublicAccessBlockRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (getPublicAccessBlockRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString(getPublicAccessBlockRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/configuration/publicAccessBlock";
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

