/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeletePublicAccessBlockRequestMarshaller
implements Marshaller<Request<DeletePublicAccessBlockRequest>, DeletePublicAccessBlockRequest> {
    @Override
    public Request<DeletePublicAccessBlockRequest> marshall(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) {
        if (deletePublicAccessBlockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeletePublicAccessBlockRequest> request = new DefaultRequest<DeletePublicAccessBlockRequest>(deletePublicAccessBlockRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deletePublicAccessBlockRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString(deletePublicAccessBlockRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/configuration/publicAccessBlock";
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

