/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.s3control.AWSS3Control;
import com.amazonaws.services.s3control.AWSS3ControlClientBuilder;
import com.amazonaws.services.s3control.S3ControlResponseMetadata;
import com.amazonaws.services.s3control.internal.S3ControlStaxResponseHandler;
import com.amazonaws.services.s3control.model.AWSS3ControlException;
import com.amazonaws.services.s3control.model.CreateJobRequest;
import com.amazonaws.services.s3control.model.CreateJobResult;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.DeletePublicAccessBlockResult;
import com.amazonaws.services.s3control.model.DescribeJobRequest;
import com.amazonaws.services.s3control.model.DescribeJobResult;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.GetPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.ListJobsRequest;
import com.amazonaws.services.s3control.model.ListJobsResult;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockRequest;
import com.amazonaws.services.s3control.model.PutPublicAccessBlockResult;
import com.amazonaws.services.s3control.model.UpdateJobPriorityRequest;
import com.amazonaws.services.s3control.model.UpdateJobPriorityResult;
import com.amazonaws.services.s3control.model.UpdateJobStatusRequest;
import com.amazonaws.services.s3control.model.UpdateJobStatusResult;
import com.amazonaws.services.s3control.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.CreateJobResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DeletePublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DeletePublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.DescribeJobRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.DescribeJobResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.GetPublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.GetPublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.IdempotencyExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.JobStatusExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.ListJobsResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.NoSuchPublicAccessBlockConfigurationExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PutPublicAccessBlockRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.PutPublicAccessBlockResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobPriorityRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobPriorityResultStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobStatusRequestMarshaller;
import com.amazonaws.services.s3control.model.transform.UpdateJobStatusResultStaxUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

@ThreadSafe
public class AWSS3ControlClient
extends AmazonWebServiceClient
implements AWSS3Control {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSS3Control.class);
    private static final String DEFAULT_SIGNING_NAME = "s3";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public static AWSS3ControlClientBuilder builder() {
        return AWSS3ControlClientBuilder.standard();
    }

    AWSS3ControlClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSS3ControlClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new JobStatusExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IdempotencyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchPublicAccessBlockConfigurationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyRequestsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BadRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller(AWSS3ControlException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("s3-control");
        this.setEndpoint("s3-control.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/s3control/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/s3control/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateJobResult executeCreateJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestMarshaller().marshall(super.beforeMarshalling(createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<CreateJobResult> responseHandler = new S3ControlStaxResponseHandler<CreateJobResult>(new CreateJobResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePublicAccessBlockResult deletePublicAccessBlock(DeletePublicAccessBlockRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeletePublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePublicAccessBlockResult executeDeletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePublicAccessBlockRequestMarshaller().marshall(super.beforeMarshalling(deletePublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeletePublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<DeletePublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<DeletePublicAccessBlockResult>(new DeletePublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePublicAccessBlockResult deletePublicAccessBlockResult = (DeletePublicAccessBlockResult)response.getAwsResponse();
            return deletePublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJobResult describeJob(DescribeJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJobResult executeDescribeJob(DescribeJobRequest describeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRequestMarshaller().marshall(super.beforeMarshalling(describeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DescribeJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<DescribeJobResult> responseHandler = new S3ControlStaxResponseHandler<DescribeJobResult>(new DescribeJobResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobResult describeJobResult = (DescribeJobResult)response.getAwsResponse();
            return describeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPublicAccessBlockResult getPublicAccessBlock(GetPublicAccessBlockRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetPublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPublicAccessBlockResult executeGetPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPublicAccessBlockRequestMarshaller().marshall(super.beforeMarshalling(getPublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetPublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<GetPublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<GetPublicAccessBlockResult>(new GetPublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPublicAccessBlockResult getPublicAccessBlockResult = (GetPublicAccessBlockResult)response.getAwsResponse();
            return getPublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobsResult executeListJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller().marshall(super.beforeMarshalling(listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<ListJobsResult> responseHandler = new S3ControlStaxResponseHandler<ListJobsResult>(new ListJobsResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutPublicAccessBlockResult putPublicAccessBlock(PutPublicAccessBlockRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutPublicAccessBlock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutPublicAccessBlockResult executePutPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPublicAccessBlockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPublicAccessBlockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPublicAccessBlockRequestMarshaller().marshall(super.beforeMarshalling(putPublicAccessBlockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutPublicAccessBlock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<PutPublicAccessBlockResult> responseHandler = new S3ControlStaxResponseHandler<PutPublicAccessBlockResult>(new PutPublicAccessBlockResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutPublicAccessBlockResult putPublicAccessBlockResult = (PutPublicAccessBlockResult)response.getAwsResponse();
            return putPublicAccessBlockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobPriorityResult updateJobPriority(UpdateJobPriorityRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateJobPriority(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobPriorityResult executeUpdateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobPriorityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobPriorityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobPriorityRequestMarshaller().marshall(super.beforeMarshalling(updateJobPriorityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateJobPriority");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<UpdateJobPriorityResult> responseHandler = new S3ControlStaxResponseHandler<UpdateJobPriorityResult>(new UpdateJobPriorityResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateJobPriorityResult updateJobPriorityResult = (UpdateJobPriorityResult)response.getAwsResponse();
            return updateJobPriorityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateJobStatusResult updateJobStatus(UpdateJobStatusRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateJobStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateJobStatusResult executeUpdateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateJobStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateJobStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateJobStatusRequestMarshaller().marshall(super.beforeMarshalling(updateJobStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "S3 Control");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateJobStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            S3ControlStaxResponseHandler<UpdateJobStatusResult> responseHandler = new S3ControlStaxResponseHandler<UpdateJobStatusResult>(new UpdateJobStatusResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateJobStatusResult updateJobStatusResult = (UpdateJobStatusResult)response.getAwsResponse();
            return updateJobStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public S3ControlResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        ResponseMetadata metadata = this.client.getResponseMetadataForRequest(request);
        if (metadata != null) {
            return new S3ControlResponseMetadata(metadata);
        }
        return null;
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

