/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53resolver;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.route53resolver.AmazonRoute53Resolver;
import com.amazonaws.services.route53resolver.AmazonRoute53ResolverClientBuilder;
import com.amazonaws.services.route53resolver.model.AmazonRoute53ResolverException;
import com.amazonaws.services.route53resolver.model.AssociateResolverEndpointIpAddressRequest;
import com.amazonaws.services.route53resolver.model.AssociateResolverEndpointIpAddressResult;
import com.amazonaws.services.route53resolver.model.AssociateResolverRuleRequest;
import com.amazonaws.services.route53resolver.model.AssociateResolverRuleResult;
import com.amazonaws.services.route53resolver.model.CreateResolverEndpointRequest;
import com.amazonaws.services.route53resolver.model.CreateResolverEndpointResult;
import com.amazonaws.services.route53resolver.model.CreateResolverRuleRequest;
import com.amazonaws.services.route53resolver.model.CreateResolverRuleResult;
import com.amazonaws.services.route53resolver.model.DeleteResolverEndpointRequest;
import com.amazonaws.services.route53resolver.model.DeleteResolverEndpointResult;
import com.amazonaws.services.route53resolver.model.DeleteResolverRuleRequest;
import com.amazonaws.services.route53resolver.model.DeleteResolverRuleResult;
import com.amazonaws.services.route53resolver.model.DisassociateResolverEndpointIpAddressRequest;
import com.amazonaws.services.route53resolver.model.DisassociateResolverEndpointIpAddressResult;
import com.amazonaws.services.route53resolver.model.DisassociateResolverRuleRequest;
import com.amazonaws.services.route53resolver.model.DisassociateResolverRuleResult;
import com.amazonaws.services.route53resolver.model.GetResolverEndpointRequest;
import com.amazonaws.services.route53resolver.model.GetResolverEndpointResult;
import com.amazonaws.services.route53resolver.model.GetResolverRuleAssociationRequest;
import com.amazonaws.services.route53resolver.model.GetResolverRuleAssociationResult;
import com.amazonaws.services.route53resolver.model.GetResolverRulePolicyRequest;
import com.amazonaws.services.route53resolver.model.GetResolverRulePolicyResult;
import com.amazonaws.services.route53resolver.model.GetResolverRuleRequest;
import com.amazonaws.services.route53resolver.model.GetResolverRuleResult;
import com.amazonaws.services.route53resolver.model.InternalServiceErrorException;
import com.amazonaws.services.route53resolver.model.InvalidNextTokenException;
import com.amazonaws.services.route53resolver.model.InvalidParameterException;
import com.amazonaws.services.route53resolver.model.InvalidPolicyDocumentException;
import com.amazonaws.services.route53resolver.model.InvalidRequestException;
import com.amazonaws.services.route53resolver.model.InvalidTagException;
import com.amazonaws.services.route53resolver.model.LimitExceededException;
import com.amazonaws.services.route53resolver.model.ListResolverEndpointIpAddressesRequest;
import com.amazonaws.services.route53resolver.model.ListResolverEndpointIpAddressesResult;
import com.amazonaws.services.route53resolver.model.ListResolverEndpointsRequest;
import com.amazonaws.services.route53resolver.model.ListResolverEndpointsResult;
import com.amazonaws.services.route53resolver.model.ListResolverRuleAssociationsRequest;
import com.amazonaws.services.route53resolver.model.ListResolverRuleAssociationsResult;
import com.amazonaws.services.route53resolver.model.ListResolverRulesRequest;
import com.amazonaws.services.route53resolver.model.ListResolverRulesResult;
import com.amazonaws.services.route53resolver.model.ListTagsForResourceRequest;
import com.amazonaws.services.route53resolver.model.ListTagsForResourceResult;
import com.amazonaws.services.route53resolver.model.PutResolverRulePolicyRequest;
import com.amazonaws.services.route53resolver.model.PutResolverRulePolicyResult;
import com.amazonaws.services.route53resolver.model.ResourceExistsException;
import com.amazonaws.services.route53resolver.model.ResourceInUseException;
import com.amazonaws.services.route53resolver.model.ResourceNotFoundException;
import com.amazonaws.services.route53resolver.model.ResourceUnavailableException;
import com.amazonaws.services.route53resolver.model.TagResourceRequest;
import com.amazonaws.services.route53resolver.model.TagResourceResult;
import com.amazonaws.services.route53resolver.model.ThrottlingException;
import com.amazonaws.services.route53resolver.model.UnknownResourceException;
import com.amazonaws.services.route53resolver.model.UntagResourceRequest;
import com.amazonaws.services.route53resolver.model.UntagResourceResult;
import com.amazonaws.services.route53resolver.model.UpdateResolverEndpointRequest;
import com.amazonaws.services.route53resolver.model.UpdateResolverEndpointResult;
import com.amazonaws.services.route53resolver.model.UpdateResolverRuleRequest;
import com.amazonaws.services.route53resolver.model.UpdateResolverRuleResult;
import com.amazonaws.services.route53resolver.model.transform.AssociateResolverEndpointIpAddressRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.AssociateResolverEndpointIpAddressResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.AssociateResolverRuleRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.AssociateResolverRuleResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.CreateResolverEndpointRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.CreateResolverEndpointResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.CreateResolverRuleRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.CreateResolverRuleResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.DeleteResolverEndpointRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.DeleteResolverEndpointResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.DeleteResolverRuleRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.DeleteResolverRuleResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.DisassociateResolverEndpointIpAddressRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.DisassociateResolverEndpointIpAddressResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.DisassociateResolverRuleRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.DisassociateResolverRuleResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.GetResolverEndpointRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.GetResolverEndpointResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.GetResolverRuleAssociationRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.GetResolverRuleAssociationResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.GetResolverRulePolicyRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.GetResolverRulePolicyResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.GetResolverRuleRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.GetResolverRuleResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListResolverEndpointIpAddressesRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListResolverEndpointIpAddressesResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListResolverEndpointsRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListResolverEndpointsResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListResolverRuleAssociationsRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListResolverRuleAssociationsResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListResolverRulesRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListResolverRulesResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.PutResolverRulePolicyRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.PutResolverRulePolicyResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.UpdateResolverEndpointRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.UpdateResolverEndpointResultJsonUnmarshaller;
import com.amazonaws.services.route53resolver.model.transform.UpdateResolverRuleRequestProtocolMarshaller;
import com.amazonaws.services.route53resolver.model.transform.UpdateResolverRuleResultJsonUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AmazonRoute53ResolverClient
extends AmazonWebServiceClient
implements AmazonRoute53Resolver {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonRoute53Resolver.class);
    private static final String DEFAULT_SIGNING_NAME = "route53resolver";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTagException").withModeledClass(InvalidTagException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnknownResourceException").withModeledClass(UnknownResourceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withModeledClass(InvalidRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPolicyDocument").withModeledClass(InvalidPolicyDocumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceUnavailableException").withModeledClass(ResourceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withModeledClass(ThrottlingException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceErrorException").withModeledClass(InternalServiceErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceExistsException").withModeledClass(ResourceExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AmazonRoute53ResolverException.class));

    public static AmazonRoute53ResolverClientBuilder builder() {
        return AmazonRoute53ResolverClientBuilder.standard();
    }

    AmazonRoute53ResolverClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonRoute53ResolverClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("route53resolver.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53resolver/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/route53resolver/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateResolverEndpointIpAddressResult associateResolverEndpointIpAddress(AssociateResolverEndpointIpAddressRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateResolverEndpointIpAddress(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateResolverEndpointIpAddressResult executeAssociateResolverEndpointIpAddress(AssociateResolverEndpointIpAddressRequest associateResolverEndpointIpAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateResolverEndpointIpAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateResolverEndpointIpAddressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateResolverEndpointIpAddressRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateResolverEndpointIpAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssociateResolverEndpointIpAddress");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateResolverEndpointIpAddressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateResolverEndpointIpAddressResult associateResolverEndpointIpAddressResult = (AssociateResolverEndpointIpAddressResult)response.getAwsResponse();
            return associateResolverEndpointIpAddressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateResolverRuleResult associateResolverRule(AssociateResolverRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssociateResolverRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateResolverRuleResult executeAssociateResolverRule(AssociateResolverRuleRequest associateResolverRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateResolverRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateResolverRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateResolverRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(associateResolverRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "AssociateResolverRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AssociateResolverRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateResolverRuleResult associateResolverRuleResult = (AssociateResolverRuleResult)response.getAwsResponse();
            return associateResolverRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateResolverEndpointResult createResolverEndpoint(CreateResolverEndpointRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateResolverEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateResolverEndpointResult executeCreateResolverEndpoint(CreateResolverEndpointRequest createResolverEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResolverEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResolverEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResolverEndpointRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createResolverEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateResolverEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateResolverEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateResolverEndpointResult createResolverEndpointResult = (CreateResolverEndpointResult)response.getAwsResponse();
            return createResolverEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateResolverRuleResult createResolverRule(CreateResolverRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateResolverRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateResolverRuleResult executeCreateResolverRule(CreateResolverRuleRequest createResolverRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResolverRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResolverRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResolverRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createResolverRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "CreateResolverRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateResolverRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateResolverRuleResult createResolverRuleResult = (CreateResolverRuleResult)response.getAwsResponse();
            return createResolverRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResolverEndpointResult deleteResolverEndpoint(DeleteResolverEndpointRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteResolverEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResolverEndpointResult executeDeleteResolverEndpoint(DeleteResolverEndpointRequest deleteResolverEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResolverEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResolverEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResolverEndpointRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteResolverEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteResolverEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteResolverEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResolverEndpointResult deleteResolverEndpointResult = (DeleteResolverEndpointResult)response.getAwsResponse();
            return deleteResolverEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResolverRuleResult deleteResolverRule(DeleteResolverRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteResolverRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResolverRuleResult executeDeleteResolverRule(DeleteResolverRuleRequest deleteResolverRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResolverRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResolverRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResolverRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteResolverRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DeleteResolverRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteResolverRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResolverRuleResult deleteResolverRuleResult = (DeleteResolverRuleResult)response.getAwsResponse();
            return deleteResolverRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateResolverEndpointIpAddressResult disassociateResolverEndpointIpAddress(DisassociateResolverEndpointIpAddressRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateResolverEndpointIpAddress(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateResolverEndpointIpAddressResult executeDisassociateResolverEndpointIpAddress(DisassociateResolverEndpointIpAddressRequest disassociateResolverEndpointIpAddressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateResolverEndpointIpAddressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateResolverEndpointIpAddressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateResolverEndpointIpAddressRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateResolverEndpointIpAddressRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DisassociateResolverEndpointIpAddress");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateResolverEndpointIpAddressResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateResolverEndpointIpAddressResult disassociateResolverEndpointIpAddressResult = (DisassociateResolverEndpointIpAddressResult)response.getAwsResponse();
            return disassociateResolverEndpointIpAddressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateResolverRuleResult disassociateResolverRule(DisassociateResolverRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateResolverRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateResolverRuleResult executeDisassociateResolverRule(DisassociateResolverRuleRequest disassociateResolverRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateResolverRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateResolverRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateResolverRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateResolverRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "DisassociateResolverRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateResolverRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateResolverRuleResult disassociateResolverRuleResult = (DisassociateResolverRuleResult)response.getAwsResponse();
            return disassociateResolverRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResolverEndpointResult getResolverEndpoint(GetResolverEndpointRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetResolverEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResolverEndpointResult executeGetResolverEndpoint(GetResolverEndpointRequest getResolverEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResolverEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResolverEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResolverEndpointRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getResolverEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetResolverEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetResolverEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResolverEndpointResult getResolverEndpointResult = (GetResolverEndpointResult)response.getAwsResponse();
            return getResolverEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResolverRuleResult getResolverRule(GetResolverRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetResolverRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResolverRuleResult executeGetResolverRule(GetResolverRuleRequest getResolverRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResolverRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResolverRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResolverRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getResolverRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetResolverRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetResolverRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResolverRuleResult getResolverRuleResult = (GetResolverRuleResult)response.getAwsResponse();
            return getResolverRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResolverRuleAssociationResult getResolverRuleAssociation(GetResolverRuleAssociationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetResolverRuleAssociation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResolverRuleAssociationResult executeGetResolverRuleAssociation(GetResolverRuleAssociationRequest getResolverRuleAssociationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResolverRuleAssociationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResolverRuleAssociationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResolverRuleAssociationRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getResolverRuleAssociationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetResolverRuleAssociation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetResolverRuleAssociationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResolverRuleAssociationResult getResolverRuleAssociationResult = (GetResolverRuleAssociationResult)response.getAwsResponse();
            return getResolverRuleAssociationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResolverRulePolicyResult getResolverRulePolicy(GetResolverRulePolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetResolverRulePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResolverRulePolicyResult executeGetResolverRulePolicy(GetResolverRulePolicyRequest getResolverRulePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResolverRulePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResolverRulePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResolverRulePolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getResolverRulePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetResolverRulePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetResolverRulePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResolverRulePolicyResult getResolverRulePolicyResult = (GetResolverRulePolicyResult)response.getAwsResponse();
            return getResolverRulePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResolverEndpointIpAddressesResult listResolverEndpointIpAddresses(ListResolverEndpointIpAddressesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListResolverEndpointIpAddresses(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResolverEndpointIpAddressesResult executeListResolverEndpointIpAddresses(ListResolverEndpointIpAddressesRequest listResolverEndpointIpAddressesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResolverEndpointIpAddressesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResolverEndpointIpAddressesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResolverEndpointIpAddressesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listResolverEndpointIpAddressesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListResolverEndpointIpAddresses");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListResolverEndpointIpAddressesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResolverEndpointIpAddressesResult listResolverEndpointIpAddressesResult = (ListResolverEndpointIpAddressesResult)response.getAwsResponse();
            return listResolverEndpointIpAddressesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResolverEndpointsResult listResolverEndpoints(ListResolverEndpointsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListResolverEndpoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResolverEndpointsResult executeListResolverEndpoints(ListResolverEndpointsRequest listResolverEndpointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResolverEndpointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResolverEndpointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResolverEndpointsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listResolverEndpointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListResolverEndpoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListResolverEndpointsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResolverEndpointsResult listResolverEndpointsResult = (ListResolverEndpointsResult)response.getAwsResponse();
            return listResolverEndpointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResolverRuleAssociationsResult listResolverRuleAssociations(ListResolverRuleAssociationsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListResolverRuleAssociations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResolverRuleAssociationsResult executeListResolverRuleAssociations(ListResolverRuleAssociationsRequest listResolverRuleAssociationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResolverRuleAssociationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResolverRuleAssociationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResolverRuleAssociationsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listResolverRuleAssociationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListResolverRuleAssociations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListResolverRuleAssociationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResolverRuleAssociationsResult listResolverRuleAssociationsResult = (ListResolverRuleAssociationsResult)response.getAwsResponse();
            return listResolverRuleAssociationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResolverRulesResult listResolverRules(ListResolverRulesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListResolverRules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResolverRulesResult executeListResolverRules(ListResolverRulesRequest listResolverRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResolverRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResolverRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResolverRulesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listResolverRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListResolverRules");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListResolverRulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResolverRulesResult listResolverRulesResult = (ListResolverRulesResult)response.getAwsResponse();
            return listResolverRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutResolverRulePolicyResult putResolverRulePolicy(PutResolverRulePolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutResolverRulePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutResolverRulePolicyResult executePutResolverRulePolicy(PutResolverRulePolicyRequest putResolverRulePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putResolverRulePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutResolverRulePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutResolverRulePolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putResolverRulePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "PutResolverRulePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutResolverRulePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutResolverRulePolicyResult putResolverRulePolicyResult = (PutResolverRulePolicyResult)response.getAwsResponse();
            return putResolverRulePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateResolverEndpointResult updateResolverEndpoint(UpdateResolverEndpointRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateResolverEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateResolverEndpointResult executeUpdateResolverEndpoint(UpdateResolverEndpointRequest updateResolverEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateResolverEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateResolverEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateResolverEndpointRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateResolverEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateResolverEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateResolverEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateResolverEndpointResult updateResolverEndpointResult = (UpdateResolverEndpointResult)response.getAwsResponse();
            return updateResolverEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateResolverRuleResult updateResolverRule(UpdateResolverRuleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateResolverRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateResolverRuleResult executeUpdateResolverRule(UpdateResolverRuleRequest updateResolverRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateResolverRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateResolverRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateResolverRuleRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateResolverRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53Resolver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateResolverRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateResolverRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateResolverRuleResult updateResolverRuleResult = (UpdateResolverRuleResult)response.getAwsResponse();
            return updateResolverRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

