/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.OutputLocation;

@SdkInternalApi
public class OutputLocationMarshaller {
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Bucket").build();
    private static final MarshallingInfo<String> S3PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Prefix").build();
    private static final OutputLocationMarshaller instance = new OutputLocationMarshaller();

    public static OutputLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutputLocation outputLocation, ProtocolMarshaller protocolMarshaller) {
        if (outputLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(outputLocation.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall(outputLocation.getS3Prefix(), S3PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

