/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.services.robomaker.model.LaunchConfig;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;

public class LaunchConfigJsonUnmarshaller
implements Unmarshaller<LaunchConfig, JsonUnmarshallerContext> {
    private static LaunchConfigJsonUnmarshaller instance;

    @Override
    public LaunchConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        LaunchConfig launchConfig = new LaunchConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("packageName", targetDepth)) {
                    context.nextToken();
                    launchConfig.setPackageName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("launchFile", targetDepth)) {
                    context.nextToken();
                    launchConfig.setLaunchFile(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("environmentVariables", targetDepth)) {
                    context.nextToken();
                    launchConfig.setEnvironmentVariables(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return launchConfig;
    }

    public static LaunchConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LaunchConfigJsonUnmarshaller();
        }
        return instance;
    }
}

