/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.Fleet;
import java.util.Date;

@SdkInternalApi
public class FleetMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LASTDEPLOYMENTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastDeploymentStatus").build();
    private static final MarshallingInfo<String> LASTDEPLOYMENTJOB_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastDeploymentJob").build();
    private static final MarshallingInfo<Date> LASTDEPLOYMENTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastDeploymentTime").timestampFormat("unixTimestamp").build();
    private static final FleetMarshaller instance = new FleetMarshaller();

    public static FleetMarshaller getInstance() {
        return instance;
    }

    public void marshall(Fleet fleet, ProtocolMarshaller protocolMarshaller) {
        if (fleet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(fleet.getName(), NAME_BINDING);
            protocolMarshaller.marshall(fleet.getArn(), ARN_BINDING);
            protocolMarshaller.marshall(fleet.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(fleet.getLastDeploymentStatus(), LASTDEPLOYMENTSTATUS_BINDING);
            protocolMarshaller.marshall(fleet.getLastDeploymentJob(), LASTDEPLOYMENTJOB_BINDING);
            protocolMarshaller.marshall(fleet.getLastDeploymentTime(), LASTDEPLOYMENTTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

