/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.DeploymentLaunchConfig;
import java.util.Map;

@SdkInternalApi
public class DeploymentLaunchConfigMarshaller {
    private static final MarshallingInfo<String> PACKAGENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("packageName").build();
    private static final MarshallingInfo<String> PRELAUNCHFILE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("preLaunchFile").build();
    private static final MarshallingInfo<String> LAUNCHFILE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchFile").build();
    private static final MarshallingInfo<String> POSTLAUNCHFILE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("postLaunchFile").build();
    private static final MarshallingInfo<Map> ENVIRONMENTVARIABLES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentVariables").build();
    private static final DeploymentLaunchConfigMarshaller instance = new DeploymentLaunchConfigMarshaller();

    public static DeploymentLaunchConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeploymentLaunchConfig deploymentLaunchConfig, ProtocolMarshaller protocolMarshaller) {
        if (deploymentLaunchConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(deploymentLaunchConfig.getPackageName(), PACKAGENAME_BINDING);
            protocolMarshaller.marshall(deploymentLaunchConfig.getPreLaunchFile(), PRELAUNCHFILE_BINDING);
            protocolMarshaller.marshall(deploymentLaunchConfig.getLaunchFile(), LAUNCHFILE_BINDING);
            protocolMarshaller.marshall(deploymentLaunchConfig.getPostLaunchFile(), POSTLAUNCHFILE_BINDING);
            protocolMarshaller.marshall(deploymentLaunchConfig.getEnvironmentVariables(), ENVIRONMENTVARIABLES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

