/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.transform.LaunchConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LaunchConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String packageName;
    private String launchFile;
    private Map<String, String> environmentVariables;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public LaunchConfig withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public void setLaunchFile(String launchFile) {
        this.launchFile = launchFile;
    }

    public String getLaunchFile() {
        return this.launchFile;
    }

    public LaunchConfig withLaunchFile(String launchFile) {
        this.setLaunchFile(launchFile);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public LaunchConfig withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.setEnvironmentVariables(environmentVariables);
        return this;
    }

    public LaunchConfig addEnvironmentVariablesEntry(String key, String value) {
        if (null == this.environmentVariables) {
            this.environmentVariables = new HashMap<String, String>();
        }
        if (this.environmentVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environmentVariables.put(key, value);
        return this;
    }

    public LaunchConfig clearEnvironmentVariablesEntries() {
        this.environmentVariables = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackageName() != null) {
            sb.append("PackageName: ").append(this.getPackageName()).append(",");
        }
        if (this.getLaunchFile() != null) {
            sb.append("LaunchFile: ").append(this.getLaunchFile()).append(",");
        }
        if (this.getEnvironmentVariables() != null) {
            sb.append("EnvironmentVariables: ").append(this.getEnvironmentVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfig)) {
            return false;
        }
        LaunchConfig other = (LaunchConfig)obj;
        if (other.getPackageName() == null ^ this.getPackageName() == null) {
            return false;
        }
        if (other.getPackageName() != null && !other.getPackageName().equals(this.getPackageName())) {
            return false;
        }
        if (other.getLaunchFile() == null ^ this.getLaunchFile() == null) {
            return false;
        }
        if (other.getLaunchFile() != null && !other.getLaunchFile().equals(this.getLaunchFile())) {
            return false;
        }
        if (other.getEnvironmentVariables() == null ^ this.getEnvironmentVariables() == null) {
            return false;
        }
        return other.getEnvironmentVariables() == null || other.getEnvironmentVariables().equals(this.getEnvironmentVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackageName() == null ? 0 : this.getPackageName().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchFile() == null ? 0 : this.getLaunchFile().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentVariables() == null ? 0 : this.getEnvironmentVariables().hashCode());
        return hashCode;
    }

    public LaunchConfig clone() {
        try {
            return (LaunchConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LaunchConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

