/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata.model.transform;

import com.amazonaws.services.rdsdata.model.Value;
import com.amazonaws.services.rdsdata.model.transform.StructValueJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import java.nio.ByteBuffer;

public class ValueJsonUnmarshaller
implements Unmarshaller<Value, JsonUnmarshallerContext> {
    private static ValueJsonUnmarshaller instance;

    @Override
    public Value unmarshall(JsonUnmarshallerContext context) throws Exception {
        Value value = new Value();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arrayValues", targetDepth)) {
                    context.nextToken();
                    value.setArrayValues(new ListUnmarshaller<Value>(ValueJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("bigIntValue", targetDepth)) {
                    context.nextToken();
                    value.setBigIntValue(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("bitValue", targetDepth)) {
                    context.nextToken();
                    value.setBitValue(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("blobValue", targetDepth)) {
                    context.nextToken();
                    value.setBlobValue(context.getUnmarshaller(ByteBuffer.class).unmarshall(context));
                }
                if (context.testExpression("doubleValue", targetDepth)) {
                    context.nextToken();
                    value.setDoubleValue(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("intValue", targetDepth)) {
                    context.nextToken();
                    value.setIntValue(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("isNull", targetDepth)) {
                    context.nextToken();
                    value.setIsNull(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("realValue", targetDepth)) {
                    context.nextToken();
                    value.setRealValue(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("stringValue", targetDepth)) {
                    context.nextToken();
                    value.setStringValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("structValue", targetDepth)) {
                    context.nextToken();
                    value.setStructValue(StructValueJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return value;
    }

    public static ValueJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ValueJsonUnmarshaller();
        }
        return instance;
    }
}

