/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rdsdata.model.StructValue;
import java.util.List;

@SdkInternalApi
public class StructValueMarshaller {
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final StructValueMarshaller instance = new StructValueMarshaller();

    public static StructValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(StructValue structValue, ProtocolMarshaller protocolMarshaller) {
        if (structValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(structValue.getAttributes(), ATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

