/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rdsdata.model.SqlParameter;

@SdkInternalApi
public class SqlParameterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").build();
    private static final SqlParameterMarshaller instance = new SqlParameterMarshaller();

    public static SqlParameterMarshaller getInstance() {
        return instance;
    }

    public void marshall(SqlParameter sqlParameter, ProtocolMarshaller protocolMarshaller) {
        if (sqlParameter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sqlParameter.getName(), NAME_BINDING);
            protocolMarshaller.marshall(sqlParameter.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

