/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ram.model.ResourceShareStatus;
import com.amazonaws.services.ram.model.Tag;
import com.amazonaws.services.ram.model.transform.ResourceShareMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ResourceShare
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceShareArn;
    private String name;
    private String owningAccountId;
    private Boolean allowExternalPrincipals;
    private String status;
    private String statusMessage;
    private List<Tag> tags;
    private Date creationTime;
    private Date lastUpdatedTime;

    public void setResourceShareArn(String resourceShareArn) {
        this.resourceShareArn = resourceShareArn;
    }

    public String getResourceShareArn() {
        return this.resourceShareArn;
    }

    public ResourceShare withResourceShareArn(String resourceShareArn) {
        this.setResourceShareArn(resourceShareArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceShare withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOwningAccountId(String owningAccountId) {
        this.owningAccountId = owningAccountId;
    }

    public String getOwningAccountId() {
        return this.owningAccountId;
    }

    public ResourceShare withOwningAccountId(String owningAccountId) {
        this.setOwningAccountId(owningAccountId);
        return this;
    }

    public void setAllowExternalPrincipals(Boolean allowExternalPrincipals) {
        this.allowExternalPrincipals = allowExternalPrincipals;
    }

    public Boolean getAllowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    public ResourceShare withAllowExternalPrincipals(Boolean allowExternalPrincipals) {
        this.setAllowExternalPrincipals(allowExternalPrincipals);
        return this;
    }

    public Boolean isAllowExternalPrincipals() {
        return this.allowExternalPrincipals;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ResourceShare withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ResourceShare withStatus(ResourceShareStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public ResourceShare withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ResourceShare withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ResourceShare withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public ResourceShare withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ResourceShare withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceShareArn() != null) {
            sb.append("ResourceShareArn: ").append(this.getResourceShareArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOwningAccountId() != null) {
            sb.append("OwningAccountId: ").append(this.getOwningAccountId()).append(",");
        }
        if (this.getAllowExternalPrincipals() != null) {
            sb.append("AllowExternalPrincipals: ").append(this.getAllowExternalPrincipals()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceShare)) {
            return false;
        }
        ResourceShare other = (ResourceShare)obj;
        if (other.getResourceShareArn() == null ^ this.getResourceShareArn() == null) {
            return false;
        }
        if (other.getResourceShareArn() != null && !other.getResourceShareArn().equals(this.getResourceShareArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOwningAccountId() == null ^ this.getOwningAccountId() == null) {
            return false;
        }
        if (other.getOwningAccountId() != null && !other.getOwningAccountId().equals(this.getOwningAccountId())) {
            return false;
        }
        if (other.getAllowExternalPrincipals() == null ^ this.getAllowExternalPrincipals() == null) {
            return false;
        }
        if (other.getAllowExternalPrincipals() != null && !other.getAllowExternalPrincipals().equals(this.getAllowExternalPrincipals())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        return other.getLastUpdatedTime() == null || other.getLastUpdatedTime().equals(this.getLastUpdatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceShareArn() == null ? 0 : this.getResourceShareArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOwningAccountId() == null ? 0 : this.getOwningAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getAllowExternalPrincipals() == null ? 0 : this.getAllowExternalPrincipals().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        return hashCode;
    }

    public ResourceShare clone() {
        try {
            return (ResourceShare)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceShareMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

