/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ram.model.ResourceShareAssociationStatus;
import com.amazonaws.services.ram.model.ResourceShareAssociationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetResourceShareAssociationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String associationType;
    private List<String> resourceShareArns;
    private String resourceArn;
    private String principal;
    private String associationStatus;
    private String nextToken;
    private Integer maxResults;

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public GetResourceShareAssociationsRequest withAssociationType(String associationType) {
        this.setAssociationType(associationType);
        return this;
    }

    public GetResourceShareAssociationsRequest withAssociationType(ResourceShareAssociationType associationType) {
        this.associationType = associationType.toString();
        return this;
    }

    public List<String> getResourceShareArns() {
        return this.resourceShareArns;
    }

    public void setResourceShareArns(Collection<String> resourceShareArns) {
        if (resourceShareArns == null) {
            this.resourceShareArns = null;
            return;
        }
        this.resourceShareArns = new ArrayList<String>(resourceShareArns);
    }

    public GetResourceShareAssociationsRequest withResourceShareArns(String ... resourceShareArns) {
        if (this.resourceShareArns == null) {
            this.setResourceShareArns(new ArrayList<String>(resourceShareArns.length));
        }
        for (String ele : resourceShareArns) {
            this.resourceShareArns.add(ele);
        }
        return this;
    }

    public GetResourceShareAssociationsRequest withResourceShareArns(Collection<String> resourceShareArns) {
        this.setResourceShareArns(resourceShareArns);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public GetResourceShareAssociationsRequest withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public GetResourceShareAssociationsRequest withPrincipal(String principal) {
        this.setPrincipal(principal);
        return this;
    }

    public void setAssociationStatus(String associationStatus) {
        this.associationStatus = associationStatus;
    }

    public String getAssociationStatus() {
        return this.associationStatus;
    }

    public GetResourceShareAssociationsRequest withAssociationStatus(String associationStatus) {
        this.setAssociationStatus(associationStatus);
        return this;
    }

    public GetResourceShareAssociationsRequest withAssociationStatus(ResourceShareAssociationStatus associationStatus) {
        this.associationStatus = associationStatus.toString();
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetResourceShareAssociationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetResourceShareAssociationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociationType() != null) {
            sb.append("AssociationType: ").append(this.getAssociationType()).append(",");
        }
        if (this.getResourceShareArns() != null) {
            sb.append("ResourceShareArns: ").append(this.getResourceShareArns()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getAssociationStatus() != null) {
            sb.append("AssociationStatus: ").append(this.getAssociationStatus()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceShareAssociationsRequest)) {
            return false;
        }
        GetResourceShareAssociationsRequest other = (GetResourceShareAssociationsRequest)obj;
        if (other.getAssociationType() == null ^ this.getAssociationType() == null) {
            return false;
        }
        if (other.getAssociationType() != null && !other.getAssociationType().equals(this.getAssociationType())) {
            return false;
        }
        if (other.getResourceShareArns() == null ^ this.getResourceShareArns() == null) {
            return false;
        }
        if (other.getResourceShareArns() != null && !other.getResourceShareArns().equals(this.getResourceShareArns())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getAssociationStatus() == null ^ this.getAssociationStatus() == null) {
            return false;
        }
        if (other.getAssociationStatus() != null && !other.getAssociationStatus().equals(this.getAssociationStatus())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociationType() == null ? 0 : this.getAssociationType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceShareArns() == null ? 0 : this.getResourceShareArns().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationStatus() == null ? 0 : this.getAssociationStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public GetResourceShareAssociationsRequest clone() {
        return (GetResourceShareAssociationsRequest)super.clone();
    }
}

