/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.PlainTextMessageType;

@SdkInternalApi
public class PlainTextMessageTypeMarshaller {
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").build();
    private static final MarshallingInfo<String> VOICEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VoiceId").build();
    private static final PlainTextMessageTypeMarshaller instance = new PlainTextMessageTypeMarshaller();

    public static PlainTextMessageTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(PlainTextMessageType plainTextMessageType, ProtocolMarshaller protocolMarshaller) {
        if (plainTextMessageType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(plainTextMessageType.getLanguageCode(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall(plainTextMessageType.getText(), TEXT_BINDING);
            protocolMarshaller.marshall(plainTextMessageType.getVoiceId(), VOICEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

