/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointsmsvoice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpointsmsvoice.model.CloudWatchLogsDestination;

@SdkInternalApi
public class CloudWatchLogsDestinationMarshaller {
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").build();
    private static final MarshallingInfo<String> LOGGROUPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupArn").build();
    private static final CloudWatchLogsDestinationMarshaller instance = new CloudWatchLogsDestinationMarshaller();

    public static CloudWatchLogsDestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchLogsDestination cloudWatchLogsDestination, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchLogsDestination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(cloudWatchLogsDestination.getIamRoleArn(), IAMROLEARN_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsDestination.getLogGroupArn(), LOGGROUPARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

