/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointemail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpointemail.model.Body;

@SdkInternalApi
public class BodyMarshaller {
    private static final MarshallingInfo<StructuredPojo> TEXT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").build();
    private static final MarshallingInfo<StructuredPojo> HTML_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Html").build();
    private static final BodyMarshaller instance = new BodyMarshaller();

    public static BodyMarshaller getInstance() {
        return instance;
    }

    public void marshall(Body body, ProtocolMarshaller protocolMarshaller) {
        if (body == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(body.getText(), TEXT_BINDING);
            protocolMarshaller.marshall(body.getHtml(), HTML_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

