/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointemail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpointemail.model.CloudWatchDestination;
import com.amazonaws.services.pinpointemail.model.EventType;
import com.amazonaws.services.pinpointemail.model.KinesisFirehoseDestination;
import com.amazonaws.services.pinpointemail.model.PinpointDestination;
import com.amazonaws.services.pinpointemail.model.SnsDestination;
import com.amazonaws.services.pinpointemail.model.transform.EventDestinationDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EventDestinationDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enabled;
    private List<String> matchingEventTypes;
    private KinesisFirehoseDestination kinesisFirehoseDestination;
    private CloudWatchDestination cloudWatchDestination;
    private SnsDestination snsDestination;
    private PinpointDestination pinpointDestination;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public EventDestinationDefinition withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getMatchingEventTypes() {
        return this.matchingEventTypes;
    }

    public void setMatchingEventTypes(Collection<String> matchingEventTypes) {
        if (matchingEventTypes == null) {
            this.matchingEventTypes = null;
            return;
        }
        this.matchingEventTypes = new ArrayList<String>(matchingEventTypes);
    }

    public EventDestinationDefinition withMatchingEventTypes(String ... matchingEventTypes) {
        if (this.matchingEventTypes == null) {
            this.setMatchingEventTypes(new ArrayList<String>(matchingEventTypes.length));
        }
        for (String ele : matchingEventTypes) {
            this.matchingEventTypes.add(ele);
        }
        return this;
    }

    public EventDestinationDefinition withMatchingEventTypes(Collection<String> matchingEventTypes) {
        this.setMatchingEventTypes(matchingEventTypes);
        return this;
    }

    public EventDestinationDefinition withMatchingEventTypes(EventType ... matchingEventTypes) {
        ArrayList<String> matchingEventTypesCopy = new ArrayList<String>(matchingEventTypes.length);
        for (EventType value : matchingEventTypes) {
            matchingEventTypesCopy.add(value.toString());
        }
        if (this.getMatchingEventTypes() == null) {
            this.setMatchingEventTypes(matchingEventTypesCopy);
        } else {
            this.getMatchingEventTypes().addAll(matchingEventTypesCopy);
        }
        return this;
    }

    public void setKinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
        this.kinesisFirehoseDestination = kinesisFirehoseDestination;
    }

    public KinesisFirehoseDestination getKinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public EventDestinationDefinition withKinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
        this.setKinesisFirehoseDestination(kinesisFirehoseDestination);
        return this;
    }

    public void setCloudWatchDestination(CloudWatchDestination cloudWatchDestination) {
        this.cloudWatchDestination = cloudWatchDestination;
    }

    public CloudWatchDestination getCloudWatchDestination() {
        return this.cloudWatchDestination;
    }

    public EventDestinationDefinition withCloudWatchDestination(CloudWatchDestination cloudWatchDestination) {
        this.setCloudWatchDestination(cloudWatchDestination);
        return this;
    }

    public void setSnsDestination(SnsDestination snsDestination) {
        this.snsDestination = snsDestination;
    }

    public SnsDestination getSnsDestination() {
        return this.snsDestination;
    }

    public EventDestinationDefinition withSnsDestination(SnsDestination snsDestination) {
        this.setSnsDestination(snsDestination);
        return this;
    }

    public void setPinpointDestination(PinpointDestination pinpointDestination) {
        this.pinpointDestination = pinpointDestination;
    }

    public PinpointDestination getPinpointDestination() {
        return this.pinpointDestination;
    }

    public EventDestinationDefinition withPinpointDestination(PinpointDestination pinpointDestination) {
        this.setPinpointDestination(pinpointDestination);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getMatchingEventTypes() != null) {
            sb.append("MatchingEventTypes: ").append(this.getMatchingEventTypes()).append(",");
        }
        if (this.getKinesisFirehoseDestination() != null) {
            sb.append("KinesisFirehoseDestination: ").append(this.getKinesisFirehoseDestination()).append(",");
        }
        if (this.getCloudWatchDestination() != null) {
            sb.append("CloudWatchDestination: ").append(this.getCloudWatchDestination()).append(",");
        }
        if (this.getSnsDestination() != null) {
            sb.append("SnsDestination: ").append(this.getSnsDestination()).append(",");
        }
        if (this.getPinpointDestination() != null) {
            sb.append("PinpointDestination: ").append(this.getPinpointDestination());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestinationDefinition)) {
            return false;
        }
        EventDestinationDefinition other = (EventDestinationDefinition)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getMatchingEventTypes() == null ^ this.getMatchingEventTypes() == null) {
            return false;
        }
        if (other.getMatchingEventTypes() != null && !other.getMatchingEventTypes().equals(this.getMatchingEventTypes())) {
            return false;
        }
        if (other.getKinesisFirehoseDestination() == null ^ this.getKinesisFirehoseDestination() == null) {
            return false;
        }
        if (other.getKinesisFirehoseDestination() != null && !other.getKinesisFirehoseDestination().equals(this.getKinesisFirehoseDestination())) {
            return false;
        }
        if (other.getCloudWatchDestination() == null ^ this.getCloudWatchDestination() == null) {
            return false;
        }
        if (other.getCloudWatchDestination() != null && !other.getCloudWatchDestination().equals(this.getCloudWatchDestination())) {
            return false;
        }
        if (other.getSnsDestination() == null ^ this.getSnsDestination() == null) {
            return false;
        }
        if (other.getSnsDestination() != null && !other.getSnsDestination().equals(this.getSnsDestination())) {
            return false;
        }
        if (other.getPinpointDestination() == null ^ this.getPinpointDestination() == null) {
            return false;
        }
        return other.getPinpointDestination() == null || other.getPinpointDestination().equals(this.getPinpointDestination());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getMatchingEventTypes() == null ? 0 : this.getMatchingEventTypes().hashCode());
        hashCode = 31 * hashCode + (this.getKinesisFirehoseDestination() == null ? 0 : this.getKinesisFirehoseDestination().hashCode());
        hashCode = 31 * hashCode + (this.getCloudWatchDestination() == null ? 0 : this.getCloudWatchDestination().hashCode());
        hashCode = 31 * hashCode + (this.getSnsDestination() == null ? 0 : this.getSnsDestination().hashCode());
        hashCode = 31 * hashCode + (this.getPinpointDestination() == null ? 0 : this.getPinpointDestination().hashCode());
        return hashCode;
    }

    public EventDestinationDefinition clone() {
        try {
            return (EventDestinationDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventDestinationDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

