/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointemail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpointemail.model.CloudWatchDimensionConfiguration;
import com.amazonaws.services.pinpointemail.model.transform.CloudWatchDestinationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CloudWatchDestination
implements Serializable,
Cloneable,
StructuredPojo {
    private List<CloudWatchDimensionConfiguration> dimensionConfigurations;

    public List<CloudWatchDimensionConfiguration> getDimensionConfigurations() {
        return this.dimensionConfigurations;
    }

    public void setDimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations) {
        if (dimensionConfigurations == null) {
            this.dimensionConfigurations = null;
            return;
        }
        this.dimensionConfigurations = new ArrayList<CloudWatchDimensionConfiguration>(dimensionConfigurations);
    }

    public CloudWatchDestination withDimensionConfigurations(CloudWatchDimensionConfiguration ... dimensionConfigurations) {
        if (this.dimensionConfigurations == null) {
            this.setDimensionConfigurations(new ArrayList<CloudWatchDimensionConfiguration>(dimensionConfigurations.length));
        }
        for (CloudWatchDimensionConfiguration ele : dimensionConfigurations) {
            this.dimensionConfigurations.add(ele);
        }
        return this;
    }

    public CloudWatchDestination withDimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations) {
        this.setDimensionConfigurations(dimensionConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensionConfigurations() != null) {
            sb.append("DimensionConfigurations: ").append(this.getDimensionConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDestination)) {
            return false;
        }
        CloudWatchDestination other = (CloudWatchDestination)obj;
        if (other.getDimensionConfigurations() == null ^ this.getDimensionConfigurations() == null) {
            return false;
        }
        return other.getDimensionConfigurations() == null || other.getDimensionConfigurations().equals(this.getDimensionConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensionConfigurations() == null ? 0 : this.getDimensionConfigurations().hashCode());
        return hashCode;
    }

    public CloudWatchDestination clone() {
        try {
            return (CloudWatchDestination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchDestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

